/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import me.desht.pneumaticcraft.common.variables.TextVariableParser;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class RemoteMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity> {
    private final List<String> syncedVars;
    private final BlockPos[] lastValues;
    private final InteractionHand hand;
    public final String[] variables;
    private final UUID playerId;

    public RemoteMenu(MenuType<? extends RemoteMenu> type, int windowId, Inventory playerInventory, InteractionHand hand) {
        super(type, windowId, playerInventory);
        this.hand = hand;
        this.variables = new String[0];
        this.playerId = playerInventory.f_35978_.m_142081_();
        this.syncedVars = new ArrayList<String>(this.getRelevantVariableNames(playerInventory.f_35978_, playerInventory.f_35978_.m_21120_(hand)));
        this.lastValues = new BlockPos[this.syncedVars.size()];
    }

    private RemoteMenu(MenuType<RemoteMenu> type, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(type, windowId, playerInventory);
        this.hand = buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.variables = new String[buffer.m_130242_()];
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = buffer.m_130277_();
        }
        this.playerId = playerInventory.f_35978_.m_142081_();
        this.syncedVars = new ArrayList<String>(this.getRelevantVariableNames(playerInventory.f_35978_, playerInventory.f_35978_.m_21120_(this.hand)));
        this.lastValues = new BlockPos[this.syncedVars.size()];
    }

    public static RemoteMenu createRemoteContainer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new RemoteMenu((MenuType<RemoteMenu>)((MenuType)ModMenuTypes.REMOTE.get()), windowId, playerInventory, buffer);
    }

    public static RemoteMenu createRemoteEditorContainer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new RemoteMenu((MenuType<RemoteMenu>)((MenuType)ModMenuTypes.REMOTE_EDITOR.get()), windowId, playerInventory, buffer);
    }

    private Set<String> getRelevantVariableNames(Player player, @Nonnull ItemStack remote) {
        HashSet<String> variables = new HashSet<String>();
        CompoundTag tag = remote.m_41783_();
        if (tag != null) {
            ListTag tagList = tag.m_128437_("actionWidgets", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag widgetTag = tagList.m_128728_(i);
                if (widgetTag.m_128441_("variableName")) {
                    variables.add(widgetTag.m_128461_("variableName"));
                }
                if (widgetTag.m_128441_("enableVariable")) {
                    variables.add(widgetTag.m_128461_("enableVariable"));
                }
                TextVariableParser parser = new TextVariableParser(widgetTag.m_128461_("text"), this.playerId);
                parser.parse();
                variables.addAll(parser.getRelevantVariables());
            }
        }
        HashSet<String> result = new HashSet<String>();
        variables.forEach(varName -> {
            if (!((String)varName).isEmpty()) {
                if (!GlobalVariableHelper.hasPrefix((String)varName)) {
                    if (!player.f_19853_.f_46443_) {
                        player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.prefixReminder", varName).m_130940_(ChatFormatting.GOLD), false);
                    }
                    varName = "#" + (String)varName;
                }
                result.add((String)varName);
            }
        });
        return result;
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        for (int i = 0; i < this.lastValues.length; ++i) {
            BlockPos newValue;
            String varName = this.syncedVars.get(i);
            if (varName.isEmpty() || (newValue = GlobalVariableHelper.getPos(this.playerId, varName)) == null || newValue.equals((Object)this.lastValues[i])) continue;
            this.lastValues[i] = newValue;
            ServerPlayer serverPlayer = PneumaticCraftUtils.getPlayerFromId(this.playerId);
            if (serverPlayer == null) continue;
            NetworkHandler.sendToPlayer(new PacketSetGlobalVariable(varName, newValue), serverPlayer);
        }
    }

    @Override
    public boolean m_6875_(Player player) {
        return player.m_21120_(this.hand).m_41720_() == ModItems.REMOTE.get();
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

