/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.block.entity.UVLightBoxBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.NonDespawningItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MaterialColor;
import org.apache.commons.lang3.Validate;

public class EmptyPCBItem
extends NonDespawningItem
implements ICustomDurabilityBar {
    private static final String NBT_ETCH_PROGRESS = "pneumaticcraft:etch_progress";

    @Override
    public void m_7373_(ItemStack stack, Level player, List<Component> infoList, TooltipFlag par4) {
        super.m_7373_(stack, player, infoList, par4);
        int uvProgress = UVLightBoxBlockEntity.getExposureProgress(stack);
        int etchProgress = EmptyPCBItem.getEtchProgress(stack);
        if (etchProgress > 0) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.uvLightBox.etchProgress", etchProgress));
        }
        infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.uvLightBox.successChance", uvProgress));
        if (uvProgress < 100 && etchProgress == 0) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.uvLightBox.putInLightBox", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
        if (uvProgress > 0) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.uvLightBox.putInAcid", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static int getEtchProgress(ItemStack stack) {
        return stack.m_41782_() ? Objects.requireNonNull(stack.m_41783_()).m_128451_(NBT_ETCH_PROGRESS) : 0;
    }

    public static void setEtchProgress(ItemStack stack, int progress) {
        Validate.isTrue((progress >= 0 && progress <= 100 ? 1 : 0) != 0);
        stack.m_41784_().m_128405_(NBT_ETCH_PROGRESS, progress);
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    public int m_142158_(ItemStack pStack) {
        int progress = UVLightBoxBlockEntity.getExposureProgress(pStack);
        return Math.round((float)progress / 100.0f * 13.0f);
    }

    public int m_142159_(ItemStack pStack) {
        int progress = UVLightBoxBlockEntity.getExposureProgress(pStack);
        return progress * 2 << 16 | 0xFF;
    }

    @Override
    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        super.onEntityItemUpdate(stack, entityItem);
        if (entityItem.f_19853_.m_6425_(entityItem.m_142538_()).m_76152_().m_205067_(PneumaticCraftTags.Fluids.ETCHING_ACID)) {
            int etchProgress;
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            if ((etchProgress = EmptyPCBItem.getEtchProgress(stack)) < 100) {
                if (entityItem.f_19797_ % 60 == 0) {
                    EmptyPCBItem.setEtchProgress(stack, etchProgress + 1);
                }
                Level world = entityItem.m_20193_();
                if (world.f_46441_.nextInt(15) == 0) {
                    double x = entityItem.m_20185_() + world.f_46441_.nextDouble() * 0.3 - 0.15;
                    double y = entityItem.m_20186_() - 0.15;
                    double z = entityItem.m_20189_() + world.f_46441_.nextDouble() * 0.3 - 0.15;
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.05, 0.0);
                }
            } else if (!entityItem.f_19853_.f_46443_) {
                int successCount = 0;
                int failedCount = 0;
                int uvProgress = UVLightBoxBlockEntity.getExposureProgress(stack);
                for (int i = 0; i < stack.m_41613_(); ++i) {
                    if (entityItem.f_19853_.f_46441_.nextInt(100) <= uvProgress) {
                        ++successCount;
                        continue;
                    }
                    ++failedCount;
                }
                ItemStack successStack = new ItemStack(successCount == 0 ? (ItemLike)ModItems.FAILED_PCB.get() : (ItemLike)ModItems.UNASSEMBLED_PCB.get(), successCount == 0 ? failedCount : successCount);
                entityItem.m_32045_(successStack);
                if (successCount > 0 && failedCount > 0) {
                    ItemStack failedStack = new ItemStack((ItemLike)ModItems.FAILED_PCB.get(), failedCount);
                    entityItem.f_19853_.m_7967_((Entity)new ItemEntity(entityItem.f_19853_, entityItem.m_20185_(), entityItem.m_20186_(), entityItem.m_20189_(), failedStack));
                }
            }
        }
        return false;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)new ItemStack((ItemLike)this));
            ItemStack stack = new ItemStack((ItemLike)this);
            UVLightBoxBlockEntity.setExposureProgress(stack, 100);
            items.add((Object)stack);
        }
    }

    @Override
    public boolean shouldShowCustomDurabilityBar(ItemStack stack) {
        return EmptyPCBItem.getEtchProgress(stack) > 0;
    }

    @Override
    public int getCustomDurabilityColour(ItemStack stack) {
        return MaterialColor.f_76369_.f_76396_;
    }

    @Override
    public float getCustomDurability(ItemStack stack) {
        return (float)EmptyPCBItem.getEtchProgress(stack) / 100.0f;
    }

    @Override
    public boolean isShowingOtherBar(ItemStack stack) {
        return true;
    }
}

