/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.pressure.PressureHelper;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ScubaHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    private static final ResourceLocation ID = PneumaticRegistry.RL("scuba");

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{(PNCUpgrade)((Object)ModUpgrades.SCUBA.get())};
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        Player player = commonArmorHandler.getPlayer();
        if (!player.f_19853_.f_46443_ && enabled && commonArmorHandler.hasMinPressure(EquipmentSlot.HEAD) && player.m_20146_() < 150) {
            ItemStack helmetStack = player.m_6844_(EquipmentSlot.HEAD);
            int baseVol = ((PneumaticArmorItem)helmetStack.m_41720_()).getBaseVolume();
            int vol = PressureHelper.getUpgradedVolume(baseVol, commonArmorHandler.getUpgradeCount(EquipmentSlot.HEAD, (PNCUpgrade)((Object)ModUpgrades.VOLUME.get())));
            float airInHelmet = commonArmorHandler.getArmorPressure(EquipmentSlot.HEAD) * (float)vol;
            int playerAir = (int)Math.min((float)(300 - player.m_20146_()), airInHelmet / (float)((Integer)ConfigHelper.common().armor.scubaMultiplier.get()).intValue());
            player.m_20301_(player.m_20146_() + playerAir);
            int airUsed = playerAir * (Integer)ConfigHelper.common().armor.scubaMultiplier.get();
            commonArmorHandler.addAir(EquipmentSlot.HEAD, -airUsed);
            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.SCUBA.get(), SoundSource.PLAYERS, player.m_142538_(), 1.0f, 1.0f, false), (ServerPlayer)player);
            Vec3 eyes = player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(0.5));
            NetworkHandler.sendToAllTracking(new PacketSpawnParticle((ParticleOptions)ParticleTypes.f_123795_, eyes.f_82479_ - 0.5, eyes.f_82480_, eyes.f_82481_ - 0.5, 0.0, 0.2, 0.0, 10, 1.0, 1.0, 1.0), player.f_19853_, player.m_142538_());
        }
    }
}

