/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ProgWidgetEnergyCondition
extends ProgWidgetCondition {
    public ProgWidgetEnergyCondition() {
        super((ProgWidgetType)((Object)ModProgWidgets.CONDITION_RF.get()));
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_ENERGY;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.AREA.get()))), (Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.TEXT.get()))));
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                BlockEntity te = this.drone.world().m_7702_(pos);
                if (te == null) {
                    return false;
                }
                int energy = 0;
                for (Direction face : DirectionUtil.VALUES) {
                    if (!ProgWidgetEnergyCondition.this.getSides()[face.m_122411_()]) continue;
                    energy = Math.max(energy, this.getEnergy(te, face));
                }
                ProgWidgetEnergyCondition.this.maybeRecordMeasuredVal(this.drone, energy);
                return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(energy, ((ICondition)((Object)this.progWidget)).getRequiredCount());
            }

            private int getEnergy(BlockEntity te, Direction side) {
                return te.getCapability(CapabilityEnergy.ENERGY, side).map(IEnergyStorage::getEnergyStored).orElse(0);
            }
        };
    }
}

