/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public abstract class ProgWidgetInventoryBase
extends ProgWidgetAreaItemBase
implements ISidedWidget,
ICountWidget {
    private boolean[] accessingSides = new boolean[]{false, true, false, false, false, false};
    private boolean useCount;
    private int count = 1;

    public ProgWidgetInventoryBase(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean sideActive = false;
        for (boolean bool : this.accessingSides) {
            sideActive |= bool;
        }
        if (!sideActive) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.noSideActive", new Object[0]));
        }
    }

    @Override
    public void setSides(boolean[] sides) {
        this.accessingSides = sides;
    }

    @Override
    public boolean[] getSides() {
        return this.accessingSides;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.isUsingSides()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.accessingSides", new Object[0]));
        }
        curTooltip.add((Component)new TextComponent("\u25b6 ").m_7220_(this.getExtraStringInfo().get(0)));
        if (this.useCount) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.usingCount", this.count));
        }
    }

    protected boolean isUsingSides() {
        return true;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        boolean allSides = true;
        boolean noSides = true;
        for (boolean bool : this.accessingSides) {
            if (bool) {
                noSides = false;
                continue;
            }
            allSides = false;
        }
        if (allSides) {
            return Collections.singletonList(ALL_TEXT);
        }
        if (noSides) {
            return Collections.singletonList(NONE_TEXT);
        }
        List l = Arrays.stream(DirectionUtil.VALUES).filter(side -> this.accessingSides[side.m_122411_()]).map(ClientUtils::translateDirection).collect(Collectors.toList());
        return Collections.singletonList(new TextComponent(Strings.join(l, (String)", ")));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        for (int i = 0; i < 6; ++i) {
            if (!this.accessingSides[i]) continue;
            tag.m_128379_(Direction.m_122376_((int)i).name(), true);
        }
        if (this.useCount) {
            tag.m_128379_("useCount", true);
        }
        tag.m_128405_("count", this.count);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = tag.m_128471_(Direction.m_122376_((int)i).name());
        }
        this.useCount = tag.m_128471_("useCount");
        this.count = tag.m_128451_("count");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        for (int i = 0; i < 6; ++i) {
            buf.writeBoolean(this.accessingSides[i]);
        }
        buf.writeBoolean(this.useCount);
        buf.m_130130_(this.count);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = buf.readBoolean();
        }
        this.useCount = buf.readBoolean();
        this.count = buf.m_130242_();
    }
}

