/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.misc.RangedInt;
import me.desht.pneumaticcraft.api.universal_sensor.IBlockAndCoordinateEventSensor;
import me.desht.pneumaticcraft.api.universal_sensor.IBlockAndCoordinatePollSensor;
import me.desht.pneumaticcraft.api.universal_sensor.IEventSensorSetting;
import me.desht.pneumaticcraft.api.universal_sensor.IPollSensorSetting;
import me.desht.pneumaticcraft.api.universal_sensor.ISensorRegistry;
import me.desht.pneumaticcraft.api.universal_sensor.ISensorSetting;
import me.desht.pneumaticcraft.common.block.entity.UniversalSensorBlockEntity;
import me.desht.pneumaticcraft.common.sensor.eventSensors.BlockInteractSensor;
import me.desht.pneumaticcraft.common.sensor.eventSensors.PlayerAttackSensor;
import me.desht.pneumaticcraft.common.sensor.eventSensors.PlayerItemPickupSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockComparatorSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockHeatSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockLightLevelSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockPresenceSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.BlockRedstoneSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.ConstantSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.PlayerHealthSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.TwitchStreamerSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldDayLightSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldGlobalVariableAnalogSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldGlobalVariableSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldPlayersInServerSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldRainingSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldTicktimeSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldTimeSensor;
import me.desht.pneumaticcraft.common.sensor.pollSensors.WorldWeatherForecaster;
import me.desht.pneumaticcraft.common.sensor.pollSensors.entity.EntityInRangeSensor;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.eventbus.api.Event;

public class SensorHandler
implements ISensorRegistry {
    private static final SensorHandler INSTANCE = new SensorHandler();
    private final Map<String, ISensorSetting> sensors = new LinkedHashMap<String, ISensorSetting>();

    public static SensorHandler getInstance() {
        return INSTANCE;
    }

    public void init() {
        this.registerSensor(new EntityInRangeSensor());
        this.registerSensor(new PlayerAttackSensor());
        this.registerSensor(new PlayerItemPickupSensor());
        this.registerSensor(new BlockInteractSensor());
        this.registerSensor(new WorldDayLightSensor());
        this.registerSensor(new WorldRainingSensor());
        this.registerSensor(new WorldTimeSensor());
        this.registerSensor(new WorldWeatherForecaster());
        this.registerSensor(new WorldPlayersInServerSensor());
        this.registerSensor(new WorldTicktimeSensor());
        this.registerSensor(new WorldGlobalVariableSensor());
        this.registerSensor(new WorldGlobalVariableAnalogSensor());
        this.registerSensor(new BlockPresenceSensor());
        this.registerSensor(new BlockComparatorSensor());
        this.registerSensor(new BlockRedstoneSensor());
        this.registerSensor(new BlockLightLevelSensor());
        this.registerSensor(new BlockHeatSensor());
        this.registerSensor(new ConstantSensor());
        this.registerSensor(new TwitchStreamerSensor());
        this.registerSensor(new PlayerHealthSensor());
    }

    public ISensorSetting getSensorFromPath(String buttonPath) {
        return this.sensors.get(buttonPath);
    }

    private List<ISensorSetting> getSensorsFromPath(String buttonPath) {
        ArrayList<ISensorSetting> matchingSensors = new ArrayList<ISensorSetting>();
        for (Map.Entry<String, ISensorSetting> entry : this.sensors.entrySet()) {
            if (!entry.getKey().startsWith(buttonPath)) continue;
            matchingSensors.add(entry.getValue());
        }
        return matchingSensors;
    }

    public ISensorSetting getSensorByIndex(int index) {
        return this.getSensorsFromPath("").get(index);
    }

    public String[] getSensorNames() {
        String[] sensorNames = new String[this.sensors.size()];
        Iterator<String> iterator = this.sensors.keySet().iterator();
        for (int i = 0; i < sensorNames.length; ++i) {
            String sensorPath = iterator.next();
            sensorNames[i] = sensorPath.substring(sensorPath.lastIndexOf(47) + 1);
        }
        return sensorNames;
    }

    public ISensorSetting getSensorForName(String name) {
        String[] sensorNames = this.getSensorNames();
        for (int i = 0; i < sensorNames.length; ++i) {
            if (!sensorNames[i].equals(name)) continue;
            return this.getSensorByIndex(i);
        }
        return null;
    }

    public Set<PNCUpgrade> getUniversalSensorUpgrades() {
        HashSet<PNCUpgrade> upgrades = new HashSet<PNCUpgrade>();
        for (ISensorSetting sensor : this.sensors.values()) {
            upgrades.addAll(sensor.getRequiredUpgrades());
        }
        return upgrades;
    }

    public String[] getDirectoriesAtLocation(String path) {
        ArrayList<String> directories = new ArrayList<String>();
        for (String sensorPath : this.sensors.keySet()) {
            if (!sensorPath.startsWith(path) || sensorPath.equals(path)) continue;
            String[] folders = sensorPath.substring(path.length()).split("/");
            if (folders[0].isEmpty() && folders.length > 1) {
                if (directories.contains(folders[1])) continue;
                directories.add(folders[1]);
                continue;
            }
            if (directories.contains(folders[0])) continue;
            directories.add(folders[0]);
        }
        Object[] directoryArray = directories.toArray(new String[0]);
        Arrays.sort(directoryArray);
        return directoryArray;
    }

    private String getUpgradePrefix(ISensorSetting sensor) {
        ArrayList<PNCUpgrade> upgrades = new ArrayList<PNCUpgrade>(sensor.getRequiredUpgrades());
        upgrades.sort(Comparator.comparing(upgrade -> I18n.m_118938_((String)upgrade.getItem().m_5524_(), (Object[])new Object[0])));
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < upgrades.size(); ++i) {
            ret.append(((PNCUpgrade)((Object)upgrades.get(i))).getRegistryName()).append(i < upgrades.size() - 1 ? "_" : "/");
        }
        return ret.toString();
    }

    public Set<PNCUpgrade> getRequiredStacksFromText(String path) {
        List<ISensorSetting> sensors = this.getSensorsFromPath(path);
        return sensors.isEmpty() ? Collections.emptySet() : sensors.get(0).getRequiredUpgrades();
    }

    @Override
    public void registerSensor(ISensorSetting sensor) {
        String path = this.getUpgradePrefix(sensor) + sensor.getSensorPath();
        this.sensors.put(path, sensor);
    }

    @Override
    public void registerSensor(IBlockAndCoordinateEventSensor sensor) {
        this.registerSensor(new BlockAndCoordinateEventSensor(sensor));
    }

    @Override
    public void registerSensor(IBlockAndCoordinatePollSensor sensor) {
        this.registerSensor(new BlockAndCoordinatePollSensor(sensor));
    }

    private static class BlockAndCoordinateEventSensor
    implements IEventSensorSetting {
        private final IBlockAndCoordinateEventSensor coordinateSensor;

        BlockAndCoordinateEventSensor(IBlockAndCoordinateEventSensor sensor) {
            this.coordinateSensor = sensor;
        }

        @Override
        public String getSensorPath() {
            return this.coordinateSensor.getSensorPath();
        }

        @Override
        public boolean needsTextBox() {
            return this.coordinateSensor.needsTextBox();
        }

        @Override
        public RangedInt getTextboxIntRange() {
            return this.coordinateSensor.getTextboxIntRange();
        }

        @Override
        public List<String> getDescription() {
            return this.coordinateSensor.getDescription();
        }

        @Override
        public int emitRedstoneOnEvent(Event event, BlockEntity tile, int sensorRange, String textboxText) {
            UniversalSensorBlockEntity teUs = (UniversalSensorBlockEntity)tile;
            Set<BlockPos> positions = teUs.getGPSPositions();
            return positions.isEmpty() ? 0 : this.coordinateSensor.emitRedstoneOnEvent(event, teUs, sensorRange, positions);
        }

        @Override
        public int getRedstonePulseLength() {
            return this.coordinateSensor.getRedstonePulseLength();
        }

        @Override
        public void getAdditionalInfo(List<Component> info) {
            this.coordinateSensor.getAdditionalInfo(info);
        }

        @Override
        public Set<PNCUpgrade> getRequiredUpgrades() {
            return ImmutableSet.copyOf(this.coordinateSensor.getRequiredUpgrades());
        }

        @Override
        public boolean needsGPSTool() {
            return true;
        }
    }

    private static class BlockAndCoordinatePollSensor
    implements IPollSensorSetting {
        private final IBlockAndCoordinatePollSensor coordinateSensor;

        BlockAndCoordinatePollSensor(IBlockAndCoordinatePollSensor sensor) {
            this.coordinateSensor = sensor;
        }

        @Override
        public String getSensorPath() {
            return this.coordinateSensor.getSensorPath();
        }

        @Override
        public boolean needsTextBox() {
            return this.coordinateSensor.needsTextBox();
        }

        @Override
        public RangedInt getTextboxIntRange() {
            return this.coordinateSensor.getTextboxIntRange();
        }

        @Override
        public List<String> getDescription() {
            return this.coordinateSensor.getDescription();
        }

        @Override
        public int getPollFrequency(BlockEntity te) {
            UniversalSensorBlockEntity us = (UniversalSensorBlockEntity)te;
            Set<BlockPos> positions = us.getGPSPositions();
            int mult = positions.isEmpty() ? 1 : positions.size();
            return this.coordinateSensor.getPollFrequency() * mult;
        }

        @Override
        public int getRedstoneValue(Level level, BlockPos pos, int sensorRange, String textBoxText) {
            BlockEntity te = level.m_7702_(pos);
            if (te instanceof UniversalSensorBlockEntity) {
                UniversalSensorBlockEntity teUs = (UniversalSensorBlockEntity)te;
                Set<BlockPos> positions = teUs.getGPSPositions();
                return positions.isEmpty() ? 0 : this.coordinateSensor.getRedstoneValue(level, pos, sensorRange, textBoxText, positions);
            }
            return 0;
        }

        @Override
        public void getAdditionalInfo(List<Component> info) {
            this.coordinateSensor.getAdditionalInfo(info);
        }

        @Override
        public Set<PNCUpgrade> getRequiredUpgrades() {
            return ImmutableSet.copyOf(this.coordinateSensor.getRequiredUpgrades());
        }

        @Override
        public boolean needsGPSTool() {
            return true;
        }
    }
}

