/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class IOHelper {
    public static LazyOptional<IItemHandler> getInventoryForTE(BlockEntity te, Direction facing) {
        return te == null ? LazyOptional.empty() : te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    public static LazyOptional<IItemHandler> getInventoryForTE(BlockEntity te) {
        return IOHelper.getInventoryForTE(te, null);
    }

    public static LazyOptional<IFluidHandler> getFluidHandlerForTE(BlockEntity te, Direction facing) {
        return te == null ? LazyOptional.empty() : te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }

    public static LazyOptional<IFluidHandler> getFluidHandlerForTE(BlockEntity te) {
        return IOHelper.getFluidHandlerForTE(te, null);
    }

    public static ItemStack extract(IItemHandler handler, ItemStack requestedStack, ExtractCount countType, boolean simulate, boolean matchNBT) {
        if (requestedStack.m_41619_()) {
            return requestedStack;
        }
        if (handler != null) {
            int itemsFound = 0;
            ArrayList slotsOfInterest = Lists.newArrayList();
            for (int slot = 0; slot < handler.getSlots() && itemsFound < requestedStack.m_41613_(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.m_41619_() || !IOHelper.matchStacks(stack, requestedStack, matchNBT)) continue;
                if (countType == ExtractCount.FIRST_MATCHING) {
                    return handler.extractItem(slot, Math.min(requestedStack.m_41613_(), stack.m_41613_()), simulate);
                }
                itemsFound += stack.m_41613_();
                slotsOfInterest.add(slot);
            }
            if (countType == ExtractCount.UP_TO || itemsFound >= requestedStack.m_41613_()) {
                ItemStack exportedStack = ItemStack.f_41583_;
                int itemsNeeded = requestedStack.m_41613_();
                int totalExtracted = 0;
                Iterator iterator = slotsOfInterest.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (!IOHelper.matchStacks(stack, requestedStack, matchNBT)) continue;
                    int itemsSubtracted = Math.min(itemsNeeded, stack.m_41613_());
                    if (itemsSubtracted > 0) {
                        exportedStack = stack;
                    }
                    itemsNeeded -= itemsSubtracted;
                    ItemStack extracted = handler.extractItem(slot, itemsSubtracted, simulate);
                    totalExtracted += extracted.m_41613_();
                }
                exportedStack = exportedStack.m_41777_();
                exportedStack.m_41764_(totalExtracted);
                return exportedStack;
            }
        }
        return ItemStack.f_41583_;
    }

    private static boolean matchStacks(ItemStack stack1, ItemStack stack2, boolean matchNBT) {
        return ItemStack.m_41746_((ItemStack)stack1, (ItemStack)stack2) && (!matchNBT || ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2));
    }

    @Nonnull
    public static ItemStack insert(BlockEntity tile, ItemStack itemStack, boolean simulate) {
        for (Direction side : Direction.values()) {
            ItemStack inserted = IOHelper.getInventoryForTE(tile, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack.m_41777_(), (boolean)simulate)).orElse(ItemStack.f_41583_);
            if (inserted.m_41613_() >= itemStack.m_41613_()) continue;
            return inserted;
        }
        return itemStack;
    }

    @Nonnull
    public static ItemStack insert(BlockEntity tile, ItemStack itemStack, Direction side, boolean simulate) {
        return IOHelper.getInventoryForTE(tile, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack, (boolean)simulate)).orElse(itemStack);
    }

    @Nonnull
    public static ItemStack insert(ICapabilityProvider provider, ItemStack itemStack, Direction side, boolean simulate) {
        return provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemStack, (boolean)simulate)).orElse(itemStack);
    }

    public static boolean transferOneItem(IItemHandler input, IItemHandler output) {
        if (input == null || output == null) {
            return false;
        }
        for (int i = 0; i < input.getSlots(); ++i) {
            ItemStack extracted = input.extractItem(i, 1, true);
            if (extracted.m_41619_() || !ItemHandlerHelper.insertItemStacked((IItemHandler)output, (ItemStack)extracted, (boolean)false).m_41619_()) continue;
            input.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static void insertOrDrop(Level world, ItemStack stack, IItemHandler handler, Vec3 dropPos, boolean simulate) {
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        if (!remainder.m_41619_() && !simulate) {
            ItemEntity item = new ItemEntity(world, dropPos.m_7096_(), dropPos.m_7098_(), dropPos.m_7094_(), remainder);
            world.m_7967_((Entity)item);
        }
    }

    public static int countItems(LazyOptional<IItemHandler> cap, Predicate<ItemStack> pred) {
        return cap.map(handler -> IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0)).filter(pred).mapToInt(ItemStack::m_41613_).sum()).orElse(0);
    }

    public static enum ExtractCount {
        EXACT,
        FIRST_MATCHING,
        UP_TO;

    }
}

