/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.variables;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class GlobalVariableManager
extends SavedData {
    public static final int MAX_VARIABLE_LEN = 64;
    private static final String DATA_KEY = "PneumaticCraftGlobalVariables";
    private static final GlobalVariableManager CLIENT_INSTANCE = new GlobalVariableManager();
    private static ServerLevel overworld;
    private final Map<String, BlockPos> globalVars = new HashMap<String, BlockPos>();
    private final Map<String, ItemStack> globalItemVars = new HashMap<String, ItemStack>();
    private final Table<UUID, String, BlockPos> playerVars = HashBasedTable.create();
    private final Table<UUID, String, ItemStack> playerItemVars = HashBasedTable.create();

    public static GlobalVariableManager getInstance() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            return CLIENT_INSTANCE;
        }
        return (GlobalVariableManager)GlobalVariableManager.getOverworld().m_8895_().m_164861_(GlobalVariableManager::load, GlobalVariableManager::new, DATA_KEY);
    }

    private GlobalVariableManager() {
    }

    private static ServerLevel getOverworld() {
        if (overworld == null && (overworld = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_)) == null) {
            throw new IllegalStateException("Overworld not initialized!");
        }
        return overworld;
    }

    public static GlobalVariableManager load(CompoundTag tag) {
        GlobalVariableManager gvm = new GlobalVariableManager();
        gvm.readFromNBT(tag);
        return gvm;
    }

    boolean hasPos(String varName) {
        return this.globalVars.containsKey(varName);
    }

    boolean hasPos(UUID ownerUUID, String varName) {
        return this.playerVars.contains((Object)ownerUUID, (Object)varName);
    }

    BlockPos getPos(String varName) {
        return this.globalVars.getOrDefault(varName, BlockPos.f_121853_);
    }

    BlockPos getPos(UUID ownerUUID, String varName) {
        BlockPos pos = (BlockPos)this.playerVars.get((Object)ownerUUID, (Object)varName);
        return pos == null ? BlockPos.f_121853_ : pos;
    }

    void setPos(String varName, BlockPos pos) {
        if (!varName.isEmpty()) {
            if (pos == null) {
                this.globalVars.remove(varName);
            } else {
                this.globalVars.put(varName, pos);
            }
            this.m_77762_();
        }
    }

    void setPos(UUID ownerUUID, String varName, BlockPos coord) {
        if (!varName.isEmpty()) {
            if (coord == null) {
                this.playerVars.remove((Object)ownerUUID, (Object)varName);
            } else {
                this.playerVars.put((Object)ownerUUID, (Object)varName, (Object)coord);
            }
            this.m_77762_();
        }
    }

    void setStack(String varName, ItemStack item) {
        if (!varName.isEmpty()) {
            if (item.m_41619_()) {
                this.globalItemVars.remove(varName);
            } else {
                this.globalItemVars.put(varName, item);
            }
            this.m_77762_();
        }
    }

    void setStack(UUID ownerUUID, String varName, ItemStack item) {
        if (!varName.isEmpty()) {
            if (item.m_41619_()) {
                this.playerItemVars.remove((Object)ownerUUID, (Object)varName);
            } else {
                this.playerItemVars.put((Object)ownerUUID, (Object)varName, (Object)item);
            }
            this.m_77762_();
        }
    }

    boolean hasStack(String varName) {
        return this.globalItemVars.containsKey(varName);
    }

    boolean hasStack(UUID ownerUUID, String varName) {
        return this.playerItemVars.contains((Object)ownerUUID, (Object)varName);
    }

    ItemStack getStack(String varName) {
        return this.globalItemVars.getOrDefault(varName, ItemStack.f_41583_);
    }

    ItemStack getStack(UUID ownerUUID, String varName) {
        ItemStack stack = (ItemStack)this.playerItemVars.get((Object)ownerUUID, (Object)varName);
        return stack == null ? ItemStack.f_41583_ : stack;
    }

    private void readFromNBT(CompoundTag tag) {
        this.globalVars.clear();
        this.globalItemVars.clear();
        this.playerVars.clear();
        this.playerItemVars.clear();
        this.globalVars.putAll(this.readPosList(tag.m_128437_("globalVars", 10)));
        this.globalItemVars.putAll(this.readItemList(tag.m_128437_("globalItemVars", 10)));
        CompoundTag playerPos = tag.m_128469_("playerVars");
        for (String id : playerPos.m_128431_()) {
            this.readPosList(playerPos.m_128437_(id, 10)).forEach((k, v) -> this.playerVars.put((Object)UUID.fromString(id), k, v));
        }
        CompoundTag playerItems = tag.m_128469_("playerItemVars");
        for (String id : playerItems.m_128431_()) {
            this.readItemList(playerItems.m_128437_(id, 10)).forEach((k, v) -> this.playerItemVars.put((Object)UUID.fromString(id), k, v));
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128365_("globalVars", (Tag)this.writePosList(this.globalVars));
        tag.m_128365_("globalItemVars", (Tag)this.writeItemList(this.globalItemVars));
        CompoundTag playerPos = new CompoundTag();
        for (UUID uuid : this.playerVars.rowKeySet()) {
            playerPos.m_128365_(uuid.toString(), (Tag)this.writePosList(this.playerVars.row((Object)uuid)));
        }
        tag.m_128365_("playerVars", (Tag)playerPos);
        CompoundTag playerItems = new CompoundTag();
        for (UUID uuid : this.playerItemVars.rowKeySet()) {
            playerItems.m_128365_(uuid.toString(), (Tag)this.writeItemList(this.playerItemVars.row((Object)uuid)));
        }
        tag.m_128365_("playerItemVars", (Tag)playerItems);
        return tag;
    }

    private Map<String, BlockPos> readPosList(ListTag list) {
        HashMap<String, BlockPos> map = new HashMap<String, BlockPos>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag t = list.m_128728_(i);
            map.put(t.m_128461_("varName"), new BlockPos(t.m_128451_("x"), t.m_128451_("y"), t.m_128451_("z")));
        }
        return map;
    }

    private ListTag writePosList(Map<String, BlockPos> map) {
        ListTag list = new ListTag();
        map.forEach((key, pos) -> {
            CompoundTag t = new CompoundTag();
            t.m_128359_("varName", key);
            t.m_128405_("x", pos.m_123341_());
            t.m_128405_("y", pos.m_123342_());
            t.m_128405_("z", pos.m_123343_());
            list.add((Object)t);
        });
        return list;
    }

    private Map<String, ItemStack> readItemList(ListTag list) {
        HashMap<String, ItemStack> map = new HashMap<String, ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag t = list.m_128728_(i);
            map.put(t.m_128461_("varName"), ItemStack.m_41712_((CompoundTag)t.m_128469_("item")));
        }
        return map;
    }

    private ListTag writeItemList(Map<String, ItemStack> map) {
        ListTag list = new ListTag();
        for (Map.Entry<String, ItemStack> entry : map.entrySet()) {
            CompoundTag t = new CompoundTag();
            t.m_128359_("varName", entry.getKey());
            CompoundTag itemTag = new CompoundTag();
            entry.getValue().m_41739_(itemTag);
            t.m_128365_("item", (Tag)itemTag);
            list.add((Object)t);
        }
        return list;
    }

    public Collection<String> getAllActiveVariableNames(Player player) {
        HashSet<String> varNames = new HashSet<String>();
        varNames.addAll(this.globalVars.keySet().stream().filter(s -> !s.isEmpty()).map(s -> "%" + s).toList());
        varNames.addAll(this.globalItemVars.keySet().stream().filter(s -> !s.isEmpty()).map(s -> "%" + s).toList());
        if (player != null) {
            varNames.addAll(this.playerVars.row((Object)player.m_142081_()).keySet().stream().filter(s -> !s.isEmpty()).map(s -> "#" + s).toList());
            varNames.addAll(this.playerItemVars.row((Object)player.m_142081_()).keySet().stream().filter(s -> !s.isEmpty()).map(s -> "#" + s).toList());
        }
        return varNames;
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onServerStarting(ServerAboutToStartEvent event) {
            overworld = null;
        }
    }
}

