/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.air_blower;

import com.lgmrszd.compressedcreativity.CompressedCreativity;
import com.lgmrszd.compressedcreativity.blocks.air_blower.AirBlowerBlock;
import com.lgmrszd.compressedcreativity.blocks.common.IPneumaticTileEntity;
import com.lgmrszd.compressedcreativity.config.CommonConfig;
import com.lgmrszd.compressedcreativity.config.PressureTierConfig;
import com.lgmrszd.compressedcreativity.index.CCLang;
import com.lgmrszd.compressedcreativity.network.IObserveTileEntity;
import com.lgmrszd.compressedcreativity.network.ObservePacket;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class AirBlowerBlockEntity
extends SmartBlockEntity
implements IHaveHoveringInformation,
IHaveGoggleInformation,
IObserveTileEntity,
IAirCurrentSource,
IPneumaticTileEntity {
    public AirCurrent airCurrent;
    protected int entitySearchCooldown;
    protected int airCurrentUpdateCooldown;
    protected boolean updateAirFlow;
    protected final IAirHandlerMachine airHandler;
    private final LazyOptional<IAirHandlerMachine> airHandlerCap;
    private float airBuffer;
    private float airUsage = 0.0f;
    private float processingStatus = 0.0f;

    public AirBlowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, PressureTierConfig.CustomTier.AIR_BLOWER_TIER, (Integer)CommonConfig.AIR_BLOWER_VOLUME.get());
    }

    protected AirBlowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier pressureTier, int volume) {
        super(type, pos, state);
        this.airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler(pressureTier, volume);
        this.airHandlerCap = LazyOptional.of(() -> this.airHandler);
        this.airCurrent = new AirCurrent((IAirCurrentSource)this);
        this.updateAirFlow = true;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.f_58858_, 0);
        CCLang.translate("tooltip.pressure_summary", new Object[0]).forGoggles(tooltip);
        CCLang.translate("tooltip.pressure", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCLang.number(this.airHandler.getPressure()).translate("unit.bar", new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CCLang.translate("tooltip.air", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCLang.number(this.airHandler.getAir()).translate("unit.air", new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        float speed = this.calculateProcessingSpeed();
        if (speed > 0.0f && this.airCurrent.maxDistance > 0.0f) {
            CCLang.translate("tooltip.air_usage", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CCLang.number(this.airUsage).translate("unit.air_per_tick", new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            CCLang.translate("tooltip.processing_speed_multiplier", new Object[0]).style(ChatFormatting.GRAY).add(CCLang.number(speed).style(ChatFormatting.AQUA)).forGoggles(tooltip);
        }
        return true;
    }

    protected float calculateAirUsage() {
        return Math.max(1.0f, (float)Math.floor(this.airHandler.getPressure() * ((Double)CommonConfig.AIR_BLOWER_AIR_USAGE_PER_BAR.get()).floatValue() * 100.0f) / 100.0f);
    }

    protected float calculateProcessingSpeed() {
        float pressure = this.airHandler.getPressure();
        if (pressure < 1.0f) {
            float x = pressure - 1.0f;
            return 1.0f - x * x * x * x;
        }
        if ((double)pressure < 3.9) {
            float x = (pressure - 1.0f) / 3.9f;
            return 1.0f + x * x;
        }
        return 2.0f;
    }

    public void updateAirHandler() {
        ArrayList<Direction> sides = new ArrayList<Direction>();
        for (Direction side : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP, Direction.DOWN}) {
            if (!this.canConnectPneumatic(side)) continue;
            sides.add(side);
        }
        this.airHandler.setConnectedFaces(sides);
        CompressedCreativity.LOGGER.debug("Updated Air Handler! Side: " + this.m_58900_().m_61143_(AirBlowerBlock.FACING));
    }

    public void tick() {
        super.tick();
        this.airHandler.tick((BlockEntity)this);
        boolean server = this.f_58857_ != null && !this.f_58857_.f_46443_ || this.isVirtual();
        this.airUsage = this.calculateAirUsage();
        if (server) {
            if (this.airCurrentUpdateCooldown-- <= 0) {
                this.airCurrentUpdateCooldown = (Integer)AllConfigs.server().kinetics.fanBlockCheckRate.get();
                this.updateAirFlow = true;
            }
            if (this.airHandler.getPressure() > 0.0f && this.airCurrent.maxDistance > 0.0f) {
                this.airBuffer += this.airUsage;
                if (this.airBuffer > 1.0f) {
                    int toRemove = Math.min((int)this.airBuffer, this.airHandler.getAir());
                    this.airHandler.addAir(-toRemove);
                    this.airBuffer -= (float)toRemove;
                }
            }
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            this.updateChute();
            this.sendData();
        }
        if (this.airHandler.getPressure() <= 0.0f) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        if (this.airHandler.getPressure() > 0.0f && this.airCurrent.maxDistance > 0.0f) {
            this.processingStatus += this.calculateProcessingSpeed();
            if (Math.floor(this.processingStatus) > 1.0) {
                int air_ticks;
                for (int i = air_ticks = (int)Math.floor(this.processingStatus); i > 0; --i) {
                    this.airCurrent.tick();
                }
                this.processingStatus -= (float)air_ticks;
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.updateAirHandler();
    }

    public void invalidate() {
        super.invalidate();
        this.airHandlerCap.invalidate();
    }

    public void remove() {
        super.remove();
        this.updateChute();
    }

    public void updateChute() {
        Direction direction = (Direction)this.m_58900_().m_61143_(AirBlowerBlock.FACING);
        if (!direction.m_122434_().m_122478_()) {
            return;
        }
        BlockEntity poweredChute = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
        if (!(poweredChute instanceof ChuteBlockEntity)) {
            return;
        }
        ChuteBlockEntity chuteBE = (ChuteBlockEntity)poweredChute;
        if (direction == Direction.DOWN) {
            chuteBE.updatePull();
        } else {
            chuteBE.updatePush(1);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY && this.canConnectPneumatic(side)) {
            return this.airHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean canConnectPneumatic(Direction dir) {
        Direction orientation = (Direction)this.m_58900_().m_61143_(AirBlowerBlock.FACING);
        return dir != orientation;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("AirHandler", this.airHandler.serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.airHandler.deserializeNBT(compound.m_128469_("AirHandler"));
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }

    @Nullable
    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return this.f_58857_;
    }

    @Nonnull
    public BlockPos getAirCurrentPos() {
        return this.f_58858_;
    }

    public float getSpeed() {
        float speed = 256.0f * this.airHandler.getPressure() / this.airHandler.getDangerPressure();
        return (float)(Math.ceil(speed / 8.0f) * 8.0);
    }

    public float getMaxDistance() {
        float speed = Math.abs(this.getSpeed());
        float distanceFactor = Math.min(speed / 256.0f, 1.0f);
        return Mth.m_14179_((float)distanceFactor, (float)3.0f, (float)12.0f);
    }

    @Nonnull
    public Direction getAirflowOriginSide() {
        return (Direction)this.m_58900_().m_61143_(AirBlowerBlock.FACING);
    }

    @Nullable
    public Direction getAirFlowDirection() {
        return (Direction)this.m_58900_().m_61143_(AirBlowerBlock.FACING);
    }

    public boolean isSourceRemoved() {
        return this.f_58859_;
    }

    @Override
    public float getDangerPressure() {
        return this.airHandler.getDangerPressure();
    }
}

