/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.bracketed_pressure_tube;

import com.lgmrszd.compressedcreativity.blocks.bracketed_pressure_tube.BracketedPressureTubeBlock;
import com.lgmrszd.compressedcreativity.index.CCModsReference;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class BracketedPressureTubeBlockEntity
extends SmartBlockEntity {
    protected final IAirHandlerMachine airHandler;
    private final LazyOptional<IAirHandlerMachine> airHandlerCap;

    public BracketedPressureTubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, PressureTier.TIER_ONE, 1000);
    }

    protected BracketedPressureTubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier tier, int volume) {
        super(type, pos, state);
        this.airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler(tier, volume);
        this.airHandlerCap = LazyOptional.of(() -> this.airHandler);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new BracketedBlockEntityBehaviour((SmartBlockEntity)this));
    }

    public void initialize() {
        super.initialize();
        this.updateAirHandler();
    }

    public void invalidate() {
        super.invalidate();
        this.airHandlerCap.invalidate();
    }

    private Direction getLeakDirection() {
        Direction dir;
        if (this.airHandler.getConnectedAirHandlers((BlockEntity)this).size() == 2) {
            return null;
        }
        if (this.airHandler.getConnectedAirHandlers((BlockEntity)this).size() == 1 && (dir = ((IAirHandlerMachine.Connection)this.airHandler.getConnectedAirHandlers((BlockEntity)this).get(0)).getDirection()) != null) {
            return dir.m_122424_();
        }
        Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)BracketedPressureTubeBlock.f_55923_);
        for (Direction dir2 : Direction.values()) {
            if (dir2.m_122434_() != axis) continue;
            return dir2;
        }
        return null;
    }

    private void spawnLeakParticles(Direction dir) {
        Level world = this.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        float pressure = this.airHandler.getPressure();
        double mx = dir.m_122429_();
        double my = dir.m_122430_();
        double mz = dir.m_122431_();
        double speed = this.airHandler.getPressure() * 0.1f;
        if (this.airHandler.getAir() <= 0) {
            if (this.airHandler.getAir() < 0 && world.f_46441_.nextBoolean()) {
                world.m_7106_(CCModsReference.getAirParticle(), (double)pos.m_123341_() + 0.5 + mx, (double)pos.m_123342_() + 0.5 + my, (double)pos.m_123343_() + 0.5 + mz, mx * speed, my * speed, mz * speed);
            }
        } else if (pressure > 1.0f || pressure > 0.5f && world.f_46441_.nextBoolean() || world.f_46441_.nextInt(3) == 0) {
            world.m_7106_(CCModsReference.getAirParticle(), (double)pos.m_123341_() + 0.5 + mx * 0.6, (double)pos.m_123342_() + 0.5 + my * 0.6, (double)pos.m_123343_() + 0.5 + mz * 0.6, mx * speed, my * speed, mz * speed);
        }
    }

    public void tick() {
        Direction dir;
        boolean server;
        super.tick();
        this.airHandler.tick((BlockEntity)this);
        boolean bl = server = !this.f_58857_.f_46443_ || this.isVirtual();
        if (server) {
            this.airHandler.setSideLeaking(this.airHandler.getConnectedAirHandlers((BlockEntity)this).size() < 2 ? this.getLeakDirection() : null);
        } else if (this.airHandler.getPressure() != 0.0f && this.airHandler.getConnectedAirHandlers((BlockEntity)this).isEmpty() && (dir = this.getLeakDirection()) != null) {
            this.spawnLeakParticles(dir.m_122424_());
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("AirHandler", this.airHandler.serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.airHandler.deserializeNBT(compound.m_128469_("AirHandler"));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY && this.canConnectPneumatic(side)) {
            return this.airHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void updateAirHandler() {
        ArrayList<Direction> sides = new ArrayList<Direction>();
        for (Direction side : Direction.values()) {
            if (!this.canConnectPneumatic(side)) continue;
            sides.add(side);
        }
        this.airHandler.setConnectedFaces(sides);
    }

    public boolean canConnectPneumatic(Direction dir) {
        Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)BracketedPressureTubeBlock.f_55923_);
        return dir == null || dir.m_122434_() == axis;
    }
}

