/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.compressed_air_engine;

import com.lgmrszd.compressedcreativity.blocks.common.IPneumaticTileEntity;
import com.lgmrszd.compressedcreativity.blocks.compressed_air_engine.CompressedAirEngineBlock;
import com.lgmrszd.compressedcreativity.config.CommonConfig;
import com.lgmrszd.compressedcreativity.config.PressureTierConfig;
import com.lgmrszd.compressedcreativity.index.CCLang;
import com.lgmrszd.compressedcreativity.network.IObserveTileEntity;
import com.lgmrszd.compressedcreativity.network.ObservePacket;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class CompressedAirEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IPneumaticTileEntity,
IObserveTileEntity {
    protected final IAirHandlerMachine airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler((PressureTier)PressureTierConfig.CustomTier.COMPRESSED_AIR_ENGINE_TIER, ((Integer)CommonConfig.COMPRESSED_AIR_ENGINE_VOLUME.get()).intValue());
    private final LazyOptional<IAirHandlerMachine> airHandlerCap = LazyOptional.of(() -> this.airHandler);
    private float airUsage;
    private float airBuffer;
    private boolean working = false;

    public CompressedAirEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.f_58858_, 0);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        CCLang.translate("tooltip.pressure_summary", new Object[0]).forGoggles(tooltip);
        CCLang.translate("tooltip.pressure", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCLang.number(this.airHandler.getPressure()).translate("unit.bar", new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CCLang.translate("tooltip.air", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCLang.number(this.airHandler.getAir()).translate("unit.air", new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CCLang.translate("tooltip.air_usage", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCLang.number((double)this.airHandler.getPressure() < (Double)CommonConfig.COMPRESSED_AIR_ENGINE_WORK_PRESSURE.get() || this.overStressed ? (double)Math.min(((Double)CommonConfig.COMPRESSED_AIR_ENGINE_AIR_USAGE_IDLE.get()).floatValue(), (float)this.airHandler.getAir()) : (double)((Double)CommonConfig.COMPRESSED_AIR_ENGINE_AIR_USAGE_WORK.get()).floatValue()).translate("unit.air_per_tick", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToTooltip(tooltip, isPlayerSneaking);
        if (this.airHandler.getAir() > 0 && ((double)this.airHandler.getPressure() < (Double)CommonConfig.COMPRESSED_AIR_ENGINE_WORK_PRESSURE.get() || this.overStressed)) {
            added = true;
            CCLang.translate("tooltip.compressed_air_engine.idle_1", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            CCLang.translate("tooltip.compressed_air_engine.idle_2", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        return added;
    }

    public void initialize() {
        super.initialize();
        this.updateAirHandler();
        this.updateGeneratedRotation();
        this.airUsage = ((Double)CommonConfig.COMPRESSED_AIR_ENGINE_AIR_USAGE_IDLE.get()).floatValue();
        this.airBuffer = 0.0f;
    }

    public void updateAirHandler() {
        ArrayList<Direction> sides = new ArrayList<Direction>();
        for (Direction side : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
            if (!this.canConnectPneumatic(side)) continue;
            sides.add(side);
        }
        sides.add(Direction.UP);
        this.airHandler.setConnectedFaces(sides);
    }

    public void invalidate() {
        super.invalidate();
        this.airHandlerCap.invalidate();
    }

    public void tick() {
        boolean server;
        super.tick();
        this.airHandler.tick((BlockEntity)this);
        boolean bl = server = this.f_58857_ != null && !this.f_58857_.f_46443_ || this.isVirtual();
        if (server) {
            if (this.airHandler.getAir() > 0) {
                this.airBuffer += Math.min(this.airUsage, (float)this.airHandler.getAir());
                if (this.airBuffer >= 1.0f) {
                    int toRemove = (int)this.airBuffer;
                    this.airHandler.addAir(-toRemove);
                    this.airBuffer -= (float)toRemove;
                }
            }
            if (this.working) {
                this.airUsage = this.isOverStressed() ? ((Double)CommonConfig.COMPRESSED_AIR_ENGINE_AIR_USAGE_IDLE.get()).floatValue() : ((Double)CommonConfig.COMPRESSED_AIR_ENGINE_AIR_USAGE_WORK.get()).floatValue();
                if ((double)this.airHandler.getPressure() < (Double)CommonConfig.COMPRESSED_AIR_ENGINE_WORK_PRESSURE.get()) {
                    this.working = false;
                    this.airUsage = ((Double)CommonConfig.COMPRESSED_AIR_ENGINE_AIR_USAGE_IDLE.get()).floatValue();
                    this.updateGeneratedRotation();
                }
            } else if ((double)this.airHandler.getPressure() >= (Double)CommonConfig.COMPRESSED_AIR_ENGINE_WORK_PRESSURE.get()) {
                this.working = true;
                this.airUsage = this.overStressed ? ((Double)CommonConfig.COMPRESSED_AIR_ENGINE_AIR_USAGE_IDLE.get()).floatValue() : ((Double)CommonConfig.COMPRESSED_AIR_ENGINE_AIR_USAGE_WORK.get()).floatValue();
                this.updateGeneratedRotation();
            }
        }
    }

    public float getGeneratedSpeed() {
        return CompressedAirEngineBlockEntity.convertToDirection((float)(this.working ? 256.0f : 0.0f), (Direction)((Direction)this.m_58900_().m_61143_(CompressedAirEngineBlock.HORIZONTAL_FACING)));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("AirHandler", this.airHandler.serializeNBT());
        if (clientPacket) {
            compound.m_128379_("working", this.working);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.airHandler.deserializeNBT(compound.m_128469_("AirHandler"));
        if (clientPacket) {
            this.working = compound.m_128471_("working");
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY && this.canConnectPneumatic(side)) {
            return this.airHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean canConnectPneumatic(Direction dir) {
        return dir == Direction.UP || dir == null || dir == this.m_58900_().m_61143_(CompressedAirEngineBlock.HORIZONTAL_FACING) && (Boolean)this.m_58900_().m_61143_((Property)CompressedAirEngineBlock.FRONT) == false || dir == ((Direction)this.m_58900_().m_61143_(CompressedAirEngineBlock.HORIZONTAL_FACING)).m_122424_() && (Boolean)this.m_58900_().m_61143_((Property)CompressedAirEngineBlock.BACK) == false;
    }

    @Override
    public float getDangerPressure() {
        return this.airHandler.getDangerPressure();
    }
}

