/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.content.airhandler_backtank;

import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class AirHandlerBacktankBlockEntity
implements IAirHandlerMachine {
    private final float MAX_PRESSURE = 3.0f;
    private final int RATIO = 2;
    private int volume;
    private int maxVolume;
    private final BacktankBlockEntity BacktankBE;
    private IAirHandlerMachine connectedAirHandler;
    private int delta;

    public AirHandlerBacktankBlockEntity(BacktankBlockEntity BacktankBE) {
        this.BacktankBE = BacktankBE;
        this.maxVolume = 2 * (Integer)AllConfigs.server().equipment.airInBacktank.get();
        this.volume = (int)((float)this.maxVolume / 3.0f);
        this.delta = 0;
        this.connectedAirHandler = null;
    }

    public void updateVolumeFromEnchant(int capacityEnchantLevel) {
        this.maxVolume = 2 * BacktankUtil.maxAir((int)capacityEnchantLevel);
        this.volume = (int)((float)this.maxVolume / 3.0f);
    }

    public void setPressure(float newPressure) {
    }

    public void setVolumeUpgrades(int newVolumeUpgrades) {
    }

    public void enableSafetyVenting(Predicate<Float> pressureCheck, Direction dir) {
    }

    public void disableSafetyVenting() {
    }

    public void tick(BlockEntity ownerTE) {
        if (!(ownerTE instanceof BacktankBlockEntity)) {
            return;
        }
        BacktankBlockEntity bbe = (BacktankBlockEntity)ownerTE;
        if (this.BacktankBE != bbe) {
            return;
        }
        Level world = Objects.requireNonNull(ownerTE.m_58904_());
        if (!world.f_46443_) {
            this.disperseAir();
        }
        if (this.delta > 5) {
            this.delta = 0;
        }
    }

    private void disperseAir() {
        if (this.connectedAirHandler == null) {
            BlockEntity blockEntityBelow = Objects.requireNonNull(this.BacktankBE.m_58904_()).m_7702_(this.BacktankBE.m_58899_().m_142300_(Direction.DOWN));
            if (blockEntityBelow == null) {
                return;
            }
            LazyOptional lazyCap = blockEntityBelow.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY);
            lazyCap.ifPresent(cap -> {
                this.connectedAirHandler = cap;
                lazyCap.addListener(self -> {
                    this.connectedAirHandler = null;
                });
            });
        }
        if (this.connectedAirHandler == null) {
            return;
        }
        if (this.connectedAirHandler.getPressure() > this.getPressure()) {
            return;
        }
        int totalVolume = this.getVolume();
        int totalAir = this.getAir();
        int totalMachineAir = (int)((long)(totalAir += this.connectedAirHandler.getAir()) * (long)this.connectedAirHandler.getVolume() / (long)(totalVolume += this.connectedAirHandler.getVolume()));
        int air = Math.max(0, totalMachineAir - this.connectedAirHandler.getAir());
        if (air != 0) {
            this.connectedAirHandler.addAir(air);
            this.addAir(-air);
        }
    }

    public void setSideLeaking(@Nullable Direction dir) {
    }

    @Nullable
    public Direction getSideLeaking() {
        return null;
    }

    public List<IAirHandlerMachine.Connection> getConnectedAirHandlers(BlockEntity ownerTE) {
        return Collections.emptyList();
    }

    public Tag serializeNBT() {
        return null;
    }

    public void deserializeNBT(CompoundTag compound) {
    }

    public void setConnectedFaces(List<Direction> sides) {
    }

    public float getPressure() {
        return (float)this.getAir() / (float)this.volume;
    }

    public int getAir() {
        return 2 * this.BacktankBE.getAirLevel() + this.delta;
    }

    public void addAir(int amount) {
        int total = this.getAir() + amount;
        int transformed = Math.min(total, this.maxVolume) / 2;
        this.delta = total - transformed * 2;
        this.BacktankBE.setAirLevel(transformed);
    }

    public int getBaseVolume() {
        return this.volume;
    }

    public void setBaseVolume(int newBaseVolume) {
    }

    public int getVolume() {
        return this.volume;
    }

    public float maxPressure() {
        return 3.0f;
    }

    public float getDangerPressure() {
        return 3.0f;
    }

    public float getCriticalPressure() {
        return 3.0f;
    }

    public void printManometerMessage(Player player, List<Component> curInfo) {
        curInfo.add((Component)new TranslatableComponent("pneumaticcraft.gui.tooltip.pressure", new Object[]{PneumaticCraftUtils.roundNumberTo((double)this.getPressure(), (int)1)}));
    }
}

