/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.network;

import com.lgmrszd.compressedcreativity.network.CCNetwork;
import com.lgmrszd.compressedcreativity.network.IUpdateBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ForceUpdatePacket {
    private BlockPos pos;

    public ForceUpdatePacket(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(ForceUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
    }

    public static ForceUpdatePacket decode(FriendlyByteBuf buf) {
        return new ForceUpdatePacket(buf.m_130135_());
    }

    public static void handle(ForceUpdatePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ForceUpdatePacket.handlePacket(packet, context));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(ForceUpdatePacket packet, Supplier<NetworkEvent.Context> context) {
        BlockPos pos = packet.pos;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || !level.m_46749_(pos)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IUpdateBlockEntity)) {
            return;
        }
        IUpdateBlockEntity ube = (IUpdateBlockEntity)blockEntity;
        ube.forceUpdate();
    }

    public static void send(Level world, BlockPos pos) {
        CCNetwork.NETWORK.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)16.0, (ResourceKey)world.m_46472_())), (Object)new ForceUpdatePacket(pos));
    }
}

