/*
 * Decompiled with CFR 0.152.
 */
package net.t2thatguy.vault_autocrafting.ae2.mixin;

import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingSubmitErrorCode;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.crafting.execution.CraftingCpuLogic;
import appeng.crafting.execution.CraftingSubmitResult;
import iskallia.vault.research.Restrictions;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.t2thatguy.vault_autocrafting.ae2.utils.AutocraftingError;
import net.t2thatguy.vault_autocrafting.core.api.ILockedCraft;
import net.t2thatguy.vault_autocrafting.core.utils.ResearchHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingCpuLogic.class})
public class CraftingCpuLogicMixin {
    @Inject(method={"trySubmitJob"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void trySubmitJob(IGrid grid, ICraftingPlan plan, IActionSource src, @Nullable ICraftingRequester requester, CallbackInfoReturnable<ICraftingSubmitResult> cir) {
        ILockedCraft craft = null;
        Item item = (Item)ForgeRegistries.ITEMS.getValue(plan.finalOutput().what().getId());
        ItemStack stack = new ItemStack((ItemLike)item);
        ServerPlayer player = src.player().map(p -> {
            ServerPlayer serverPlayer;
            return p instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)p) : null;
        }).orElse(null);
        if (player == null) {
            IActionHost machine = src.machine().orElse(null);
            if (machine == null) {
                cir.setReturnValue((Object)CraftingSubmitResult.INCOMPLETE_PLAN);
                cir.cancel();
                return;
            }
            IGridNode node = machine.getActionableNode();
            IPlayerRegistry playerRegistry = IPlayerRegistry.getMapping((Level)node.getLevel());
            @Nullable UUID playerId = playerRegistry.getProfileId(node.getOwningPlayerId());
            if (playerId == null) {
                cir.setReturnValue((Object)CraftingSubmitResult.INCOMPLETE_PLAN);
                cir.cancel();
                return;
            }
            craft = ResearchHelper.isRestricted(playerId, stack, Restrictions.Type.CRAFTABILITY, node.getLevel());
        } else {
            craft = ResearchHelper.isRestricted(player, stack, Restrictions.Type.CRAFTABILITY);
        }
        if (craft.getIsLocked()) {
            AutocraftingError err = new AutocraftingError(craft.getResearchName());
            cir.setReturnValue((Object)new CraftingSubmitResult(null, CraftingSubmitErrorCode.INCOMPLETE_PLAN, (Object)err));
            cir.cancel();
            return;
        }
    }
}

