/*
 * Decompiled with CFR 0.152.
 */
package net.t2thatguy.vault_autocrafting.ae2.mixin;

import appeng.api.networking.crafting.CraftingSubmitErrorCode;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.crafting.execution.CraftingSubmitResult;
import appeng.menu.me.crafting.CraftConfirmMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.t2thatguy.vault_autocrafting.ae2.utils.AutocraftingError;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftConfirmMenu.SyncableSubmitResult.class}, remap=false)
public class SyncableSubmitResultMixin {
    @Shadow
    public ICraftingSubmitResult result;

    @Inject(method={"writeToPacket(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="TAIL")})
    public void injectWriteToPacket(FriendlyByteBuf data, CallbackInfo ci) {
        Object details;
        ICraftingSubmitResult result = this.result;
        if (result != null && !result.successful() && result.errorCode() == CraftingSubmitErrorCode.INCOMPLETE_PLAN && (details = result.errorDetail()) instanceof AutocraftingError) {
            AutocraftingError err = (AutocraftingError)details;
            data.m_130070_(err.getModName());
        }
    }

    @Inject(method={"readFromPacket(Lnet/minecraft/network/FriendlyByteBuf;)Lappeng/api/networking/crafting/ICraftingSubmitResult;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void injectReadFromPacket(FriendlyByteBuf data, CallbackInfoReturnable<ICraftingSubmitResult> cir) {
        ICraftingSubmitResult result = (ICraftingSubmitResult)cir.getReturnValue();
        if (result == null) {
            return;
        }
        CraftingSubmitErrorCode errorCode = result.errorCode();
        if (errorCode == CraftingSubmitErrorCode.INCOMPLETE_PLAN) {
            String modName = data.m_130277_();
            cir.setReturnValue((Object)new CraftingSubmitResult(null, CraftingSubmitErrorCode.INCOMPLETE_PLAN, (Object)new AutocraftingError(modName)));
        }
    }
}

