/*
 * Decompiled with CFR 0.152.
 */
package net.t2thatguy.vault_autocrafting.core.utils;

import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.Restrictions;
import iskallia.vault.research.StageManager;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.t2thatguy.vault_autocrafting.core.api.ILockedCraft;
import net.t2thatguy.vault_autocrafting.core.utils.LockedCraft;
import org.jetbrains.annotations.Nullable;

public class ResearchHelper {
    public static HashMap<Integer, String> researchCache = new HashMap();

    private Boolean isRestrictedCached(Player player, ItemStack stack, Restrictions.Type restrictionType) {
        Integer researchHash = Objects.hash(player.m_142081_(), stack, restrictionType);
        @Nullable String cacheRes = researchCache.getOrDefault(researchHash, "");
        if (Objects.equals(cacheRes, "")) {
            return false;
        }
        ResearchTree tree = StageManager.getResearchTree((Player)player);
        String restrictedBy = tree.restrictedBy(stack, restrictionType);
        researchCache.put(researchHash, restrictedBy);
        if (restrictedBy == null) {
            return false;
        }
        return true;
    }

    public static ILockedCraft isRestricted(ServerPlayer player, ItemStack stack, Restrictions.Type restrictionType) {
        return ResearchHelper.isRestricted(player.m_142081_(), stack, restrictionType, player.m_183503_());
    }

    public static ILockedCraft isRestricted(UUID uuid, ItemStack stack, Restrictions.Type restrictionType, ServerLevel level) {
        PlayerResearchesData researchData = PlayerResearchesData.get((ServerLevel)level);
        ResearchTree tree = researchData.getResearches(uuid);
        @Nullable String restrictedBy = tree.restrictedBy(stack, restrictionType);
        return new LockedCraft(restrictedBy);
    }
}

