/*
 * Decompiled with CFR 0.152.
 */
package net.t2thatguy.vault_autocrafting.create.mixin;

import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import iskallia.vault.research.Restrictions;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.t2thatguy.vault_autocrafting.core.api.ILockedCraft;
import net.t2thatguy.vault_autocrafting.core.utils.ResearchHelper;
import net.t2thatguy.vault_autocrafting.create.api.IMechanicalCrafterBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MechanicalCrafterBlockEntity.class}, remap=false)
public abstract class MechanicalCrafterBlockEntityMixin
extends SmartBlockEntity
implements IMechanicalCrafterBlockEntity {
    @Unique
    @Nullable
    private UUID playerUUID;

    @Shadow
    public void ejectWholeGrid() {
    }

    public MechanicalCrafterBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void setPlacingPlayer(Player player) {
        this.playerUUID = player.m_142081_();
    }

    @Override
    @Nullable
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Inject(method={"tick"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Ljava/util/ArrayList;<init>", shift=At.Shift.BEFORE)})
    public void tick(CallbackInfo ci, boolean onClient, boolean runLogic, ItemStack result) {
        if (result == null) {
            return;
        }
        if (this.playerUUID == null) {
            return;
        }
        ILockedCraft craft = ResearchHelper.isRestricted(this.playerUUID, result, Restrictions.Type.CRAFTABILITY, (ServerLevel)this.f_58857_);
        if (craft.getIsLocked()) {
            this.ejectWholeGrid();
            ci.cancel();
        }
    }

    @Inject(method={"write"}, at={@At(value="HEAD")})
    public void write(CompoundTag tag, boolean clientPacket, CallbackInfo ci) {
        if (!clientPacket && this.playerUUID != null) {
            tag.m_128362_("PlayerUUID", this.playerUUID);
        }
    }

    @Inject(method={"read"}, at={@At(value="HEAD")})
    public void read(CompoundTag tag, boolean clientPacket, CallbackInfo ci) {
        if (!clientPacket && tag.m_128441_("PlayerUUID")) {
            this.playerUUID = tag.m_128342_("PlayerUUID");
        }
    }
}

