/*
 * Decompiled with CFR 0.152.
 */
package net.t2thatguy.vault_autocrafting.mekanism.mixin;

import iskallia.vault.research.Restrictions;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.security.IOwnerObject;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.assemblicator.RecipeFormula;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.block.state.BlockState;
import net.t2thatguy.vault_autocrafting.core.api.ILockedCraft;
import net.t2thatguy.vault_autocrafting.core.utils.ResearchHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileEntityFormulaicAssemblicator.class}, remap=false)
public class TileEntityFormulaicAssemblicatorMixin
extends TileEntityConfigurableMachine {
    @Shadow
    private ItemStack lastOutputStack;
    @Shadow
    private NonNullList<ItemStack> lastRemainingItems;
    @Shadow
    private int operatingTicks;

    public TileEntityFormulaicAssemblicatorMixin(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Unique
    public boolean vault_autocrafting$isRecipeLocked(UUID uuid, ItemStack item) {
        ILockedCraft lockedCraft = ResearchHelper.isRestricted(uuid, item, Restrictions.Type.CRAFTABILITY, (ServerLevel)this.f_58857_);
        return lockedCraft.getIsLocked();
    }

    @Unique
    @Nullable
    public UUID vault_autocrafting$getPlayerUUID() {
        Optional ownerCapability = this.getCapability(Capabilities.OWNER_OBJECT).resolve();
        if (ownerCapability.isEmpty()) {
            return null;
        }
        return ((IOwnerObject)ownerCapability.get()).getOwnerUUID();
    }

    @Unique
    public boolean vault_autocrafting$isValidFormula(RecipeFormula instance) {
        boolean isValid = instance.isValidFormula();
        if (!isValid) {
            return false;
        }
        CraftingRecipe cRecipe = instance.getRecipe();
        if (cRecipe == null) {
            return true;
        }
        ItemStack item = cRecipe.m_8043_();
        UUID playerUUID = this.vault_autocrafting$getPlayerUUID();
        if (playerUUID == null) {
            return false;
        }
        return !this.vault_autocrafting$isRecipeLocked(playerUUID, item);
    }

    @Redirect(method={"loadFormula"}, at=@At(value="INVOKE", target="Lmekanism/common/content/assemblicator/RecipeFormula;isValidFormula()Z"))
    public boolean redirectLoadFormula(RecipeFormula instance) {
        return this.vault_autocrafting$isValidFormula(instance);
    }

    @Redirect(method={"recalculateRecipe"}, at=@At(value="INVOKE", target="Lmekanism/common/content/assemblicator/RecipeFormula;isValidFormula()Z"))
    public boolean redirectRecalculateRecipe(RecipeFormula instance) {
        return this.vault_autocrafting$isValidFormula(instance);
    }

    @Redirect(method={"encodeFormula"}, at=@At(value="INVOKE", target="Lmekanism/common/content/assemblicator/RecipeFormula;isValidFormula()Z"))
    public boolean redirectEncodeFormula(RecipeFormula instance) {
        return this.vault_autocrafting$isValidFormula(instance);
    }

    @Redirect(method={"hasValidFormula"}, at=@At(value="INVOKE", target="Lmekanism/common/content/assemblicator/RecipeFormula;isValidFormula()Z"))
    public boolean redirectHasValidFormula(RecipeFormula instance) {
        return this.vault_autocrafting$isValidFormula(instance);
    }

    @Redirect(method={"computerEncodeFormula"}, at=@At(value="INVOKE", target="Lmekanism/common/content/assemblicator/RecipeFormula;isValidFormula()Z"))
    public boolean redirectComputerEncodeFormula(RecipeFormula instance) {
        return this.vault_autocrafting$isValidFormula(instance);
    }

    @Inject(method={"doSingleCraft"}, at={@At(value="INVOKE", target="Lmekanism/common/tile/machine/TileEntityFormulaicAssemblicator;tryMoveToOutput(Lnet/minecraft/world/item/ItemStack;Lmekanism/api/Action;)Z", shift=At.Shift.BEFORE, ordinal=1)}, cancellable=true)
    public void injectDoSingleCraft(CallbackInfoReturnable<Boolean> cir) {
        ItemStack output = this.lastOutputStack;
        if (output.m_41619_()) {
            return;
        }
        UUID playerUUID = this.vault_autocrafting$getPlayerUUID();
        boolean isLocked = this.vault_autocrafting$isRecipeLocked(playerUUID, output);
        if (isLocked) {
            cir.setReturnValue((Object)false);
        }
    }
}

