/*
 * Decompiled with CFR 0.152.
 */
package net.t2thatguy.vault_autocrafting.refinedstorage.mixin;

import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingManager;
import iskallia.vault.research.Restrictions;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.t2thatguy.vault_autocrafting.VaultAutocrafting;
import net.t2thatguy.vault_autocrafting.core.api.ILockedCraft;
import net.t2thatguy.vault_autocrafting.core.utils.ResearchHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingManager.class})
public class CraftingManagerMixin {
    @Inject(method={"create"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void create(ItemStack stack, int quantity, CallbackInfoReturnable<ICalculationResult> cir) {
    }

    @Inject(method={"request"}, at={@At(value="INVOKE", target="Lcom/refinedmods/refinedstorage/apiimpl/autocrafting/CraftingManager;create")}, remap=false, cancellable=true)
    public void request(Object source, ItemStack stack, int amount, CallbackInfoReturnable<ICraftingTask> cir) {
        if (source instanceof INetworkNode) {
            INetworkNode node = (INetworkNode)source;
            UUID owner = node.getOwner();
            if (owner == null) {
                VaultAutocrafting.LOGGER.debug("Cancelled as no valid player target");
                cir.cancel();
                return;
            }
            ILockedCraft craft = ResearchHelper.isRestricted(owner, stack, Restrictions.Type.CRAFTABILITY, (ServerLevel)node.getLevel());
            if (craft.getIsLocked()) {
                cir.cancel();
            }
        }
    }
}

