/*
 * Decompiled with CFR 0.152.
 */
package net.t2thatguy.vault_autocrafting.refinedstorage.mixin;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.ExporterNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import iskallia.vault.research.Restrictions;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.t2thatguy.vault_autocrafting.VaultAutocrafting;
import net.t2thatguy.vault_autocrafting.core.api.ILockedCraft;
import net.t2thatguy.vault_autocrafting.core.utils.ResearchHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={ExporterNetworkNode.class})
public abstract class ExporterNetworkNodeMixin
extends NetworkNode {
    @Final
    @Shadow(remap=false)
    private BaseItemHandler itemFilters;
    @Shadow(remap=false)
    private int filterSlot;

    protected ExporterNetworkNodeMixin(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Redirect(method={"update"}, at=@At(value="INVOKE", target="Lcom/refinedmods/refinedstorage/api/autocrafting/ICraftingManager;request"), slice=@Slice(from=@At(value="INVOKE", target="Lcom/refinedmods/refinedstorage/api/network/INetwork;extractItem"), to=@At(value="INVOKE", target="Lnet/minecraftforge/items/ItemHandlerHelper;insertItem")), remap=false)
    public ICraftingTask update(ICraftingManager manager, Object source, ItemStack stack, int amount) {
        UUID owner = this.getOwner();
        if (owner == null) {
            VaultAutocrafting.LOGGER.debug("Cancelled as no valid player target");
            return null;
        }
        ILockedCraft craft = ResearchHelper.isRestricted(owner, stack, Restrictions.Type.CRAFTABILITY, (ServerLevel)this.level);
        if (craft.getIsLocked()) {
            return null;
        }
        return this.network.getCraftingManager().request((Object)new SlottedCraftingRequest((INetworkNode)this, this.filterSlot), stack, amount);
    }
}

