/*
 * Decompiled with CFR 0.152.
 */
package net.t2thatguy.vault_autocrafting.refinedstorage.mixin;

import com.refinedmods.refinedstorage.apiimpl.network.node.InterfaceNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import iskallia.vault.research.Restrictions;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.t2thatguy.vault_autocrafting.VaultAutocrafting;
import net.t2thatguy.vault_autocrafting.core.api.ILockedCraft;
import net.t2thatguy.vault_autocrafting.core.utils.ResearchHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={InterfaceNetworkNode.class})
public abstract class InterfaceNetworkNodeMixin
extends NetworkNode {
    @Final
    @Shadow(remap=false)
    private BaseItemHandler importItems;
    @Shadow(remap=false)
    private int currentSlot;

    protected InterfaceNetworkNodeMixin(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Inject(method={"update"}, at={@At(value="INVOKE", target="Lcom/refinedmods/refinedstorage/api/autocrafting/ICraftingManager;request")}, remap=false, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void update(CallbackInfo ci, ItemStack slot, int i, ItemStack wanted) {
        UUID owner = this.getOwner();
        if (owner == null) {
            VaultAutocrafting.LOGGER.debug("Cancelled as no valid player target");
            ci.cancel();
            return;
        }
        ILockedCraft craft = ResearchHelper.isRestricted(owner, wanted, Restrictions.Type.CRAFTABILITY, (ServerLevel)this.level);
        if (craft.getIsLocked()) {
            ci.cancel();
        }
    }
}

