/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.bridge;

import com.blamejared.jeitweaker.api.CoordinateFixer;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.recipe.RecipeGraphics;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;

public final class InputConsumingCategoryBridge
implements JeiCategoryPluginBridge {
    private static final int OUTPUT_ANIMATION_LOCATION_X = 97;
    private static final int OUTPUT_ANIMATION_LOCATION_Y = 4;
    private static final int TEXT_LOCATION_Y = 36;
    private static final int TEXT_COLOR = -1710619;
    private static final int BACKGROUND_WIDTH = 162;
    private static final int TEXT_PADDING = 4;
    private final Pair<JeiDrawable, JeiDrawable> outputExtras;
    private final Component baseExtra;

    public InputConsumingCategoryBridge(Pair<JeiDrawable, JeiDrawable> outputExtras, Component baseExtra) {
        this.outputExtras = outputExtras;
        this.baseExtra = baseExtra;
    }

    @Override
    public <G> void initializeGui(IGuiIngredientGroup<G> group, CoordinateFixer coordinateFixer) {
        group.init(0, true, coordinateFixer.fixX(41), coordinateFixer.fixY(8));
    }

    @Override
    public int getInputSlotsAmount() {
        return 1;
    }

    @Override
    public int getOutputSlotsAmount() {
        return 0;
    }

    @Override
    public boolean allowShapelessMarker() {
        return false;
    }

    @Override
    public boolean allowCustomTooltips() {
        return false;
    }

    @Override
    public void drawAdditionalComponent(PoseStack poseStack, double mouseX, double mouseY, IGuiHelper guiHelper, Consumer<RecipeGraphics> graphicsConsumer) {
        this.drawAnimation(poseStack, guiHelper);
        this.drawResultText(poseStack, graphicsConsumer);
    }

    @Override
    public List<Component> getTooltips(double x, double y, IGuiHelper helper, Consumer<RecipeGraphics> graphicsConsumer) {
        return Collections.emptyList();
    }

    private void drawAnimation(PoseStack poseStack, IGuiHelper helper) {
        IDrawable background = ((JeiDrawable)this.outputExtras.getFirst()).getDrawable(helper);
        IDrawable animation = ((JeiDrawable)this.outputExtras.getSecond()).getDrawable(helper);
        this.drawAnimation(poseStack, background, animation);
    }

    private void drawAnimation(PoseStack poseStack, IDrawable background, IDrawable animation) {
        background.draw(poseStack, 97, 4);
        if (animation != null) {
            animation.draw(poseStack, 97, 4);
        }
    }

    private void drawResultText(PoseStack poseStack, Consumer<RecipeGraphics> graphicsConsumer) {
        GatherExtraRecipeGraphics graphics = new GatherExtraRecipeGraphics();
        graphicsConsumer.accept(graphics);
        this.drawResultText(poseStack, this.baseExtra, graphics.component);
    }

    private void drawResultText(PoseStack poseStack, Component base, Component result) {
        if (base == null && result == null) {
            return;
        }
        if (base == null) {
            this.drawResultText(poseStack, result);
        } else if (result == null) {
            this.drawResultText(poseStack, base);
        } else {
            this.drawResultText(poseStack, (Component)new TextComponent("").m_7220_(base).m_130946_(" ").m_7220_(result));
        }
    }

    private void drawResultText(PoseStack poseStack, Component component) {
        Font font = Minecraft.m_91087_().f_91062_;
        int width = font.m_92852_((FormattedText)component);
        int x = (154 - width) / 2;
        font.m_92763_(poseStack, component, (float)x, 36.0f, -1710619);
    }

    private static final class GatherExtraRecipeGraphics
    implements RecipeGraphics {
        private static final String EXTRA_COMPONENT = "result_text";
        private Component component = null;

        GatherExtraRecipeGraphics() {
        }

        @Override
        public void setExtraComponent(String key, Component component) {
            if (EXTRA_COMPONENT.equals(key)) {
                this.component = component;
            }
        }
    }
}

