/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.jei;

import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.jei.JeiTweakerRecipe;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class JeiTweakerCategory
implements IRecipeCategory<JeiTweakerRecipe> {
    private final JeiCategory zenCategory;
    private final IJeiHelpers helpers;
    private final JeiCategoryPluginBridge bridge;

    JeiTweakerCategory(JeiCategory zenCategory, IJeiHelpers helpers) {
        this.zenCategory = zenCategory;
        this.helpers = helpers;
        this.bridge = zenCategory.getBridgeCreator().get();
    }

    public ResourceLocation getUid() {
        return this.zenCategory.id();
    }

    public Class<? extends JeiTweakerRecipe> getRecipeClass() {
        return JeiTweakerRecipe.class;
    }

    public IDrawable getBackground() {
        return this.zenCategory.background().getDrawable(this.helpers.getGuiHelper());
    }

    public IDrawable getIcon() {
        return this.zenCategory.icon().getDrawable(this.helpers.getGuiHelper());
    }

    public void setIngredients(JeiTweakerRecipe recipe, IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout recipeLayout, JeiTweakerRecipe recipe, IIngredients ingredients) {
        long slotsData = (long)this.bridge.getOutputSlotsAmount() << 32 | (long)this.bridge.getInputSlotsAmount();
        recipe.setRecipe(recipeLayout, this.bridge::initializeGui, slotsData, this.bridge.allowShapelessMarker());
    }

    public Component getTitle() {
        return this.zenCategory.name();
    }

    public void draw(JeiTweakerRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        this.bridge.drawAdditionalComponent(matrixStack, mouseX, mouseY, this.helpers.getGuiHelper(), recipe::populateGraphics);
    }

    public List<Component> getTooltipStrings(JeiTweakerRecipe recipe, double mouseX, double mouseY) {
        List recipeTips;
        List<Component> categoryTips = this.bridge.getTooltips(mouseX, mouseY, this.helpers.getGuiHelper(), recipe::populateGraphics);
        List<Object> list = recipeTips = this.bridge.allowCustomTooltips() ? recipe.getTooltips(mouseX, mouseY) : Collections.emptyList();
        if (categoryTips.isEmpty() && recipeTips.isEmpty()) {
            return Collections.emptyList();
        }
        Stream stream = categoryTips.isEmpty() ? recipeTips.stream() : (recipeTips.isEmpty() ? categoryTips.stream() : Stream.concat(categoryTips.stream(), recipeTips.stream()));
        return stream.toList();
    }

    public boolean handleClick(JeiTweakerRecipe recipe, double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean isHandled(JeiTweakerRecipe recipe) {
        return recipe.getOwningCategory() == this.zenCategory;
    }
}

