/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.foregoing_tweaker.laser_drill;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import mrthomas20121.foregoing_tweaker.laser_drill.CTLaserDrillRarity;
import mrthomas20121.foregoing_tweaker.laser_drill.LaserDrillRarityInterface;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.foregoing_tweaker.laser_drill.LaserDrillRarityBuilder")
@ZenRegister
public class LaserDrillRarityBuilder {
    private ResourceKey<Biome>[] whitelist = new ResourceKey[0];
    private ResourceKey<Biome>[] blacklist = new ResourceKey[0];
    private int depth_min = 0;
    private int depth_max = 255;
    private int weight = 0;

    @ZenCodeType.Constructor
    public LaserDrillRarityBuilder() {
    }

    @ZenCodeType.Method
    public LaserDrillRarityBuilder setDepthMin(int depth_min) {
        this.depth_min = depth_min;
        return this;
    }

    @ZenCodeType.Method
    public LaserDrillRarityBuilder setDepthMax(int depth_max) {
        this.depth_max = depth_max;
        return this;
    }

    @ZenCodeType.Method
    public LaserDrillRarityBuilder setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    @ZenCodeType.Method
    public LaserDrillRarityBuilder addBiomeDictToWhitelist(String dictionary) {
        Set keys = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.getType((String)dictionary, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        int length = this.whitelist.length;
        this.whitelist = Arrays.copyOf(this.whitelist, keys.size() + length);
        int i = length;
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            ResourceKey key;
            this.whitelist[i] = key = (ResourceKey)iterator.next();
            ++i;
        }
        return this;
    }

    @ZenCodeType.Method
    public LaserDrillRarityBuilder addBiomeDictToBlacklist(String dictionary) {
        Set keys = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.getType((String)dictionary, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
        int length = this.blacklist.length;
        this.blacklist = Arrays.copyOf(this.blacklist, keys.size() + length);
        int i = length;
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            ResourceKey key;
            this.blacklist[i] = key = (ResourceKey)iterator.next();
            ++i;
        }
        return this;
    }

    @ZenCodeType.Method
    public LaserDrillRarityBuilder addBiomeToWhitelist(String biome) {
        int length = this.whitelist.length;
        if (length == 0) {
            this.whitelist = new ResourceKey[]{this.getBiome(biome)};
        } else {
            this.whitelist = Arrays.copyOf(this.whitelist, length + 1);
            this.whitelist[length] = this.getBiome(biome);
        }
        return this;
    }

    @ZenCodeType.Method
    public LaserDrillRarityBuilder addBiomeToBlacklist(String biome) {
        int length = this.blacklist.length;
        if (length == 0) {
            this.blacklist = new ResourceKey[]{this.getBiome(biome)};
        } else {
            this.blacklist = Arrays.copyOf(this.blacklist, length + 1);
            this.blacklist[length] = this.getBiome(biome);
        }
        return this;
    }

    @ZenCodeType.Method
    public LaserDrillRarityInterface build() {
        return new CTLaserDrillRarity(new LaserDrillRarity(this.whitelist, this.blacklist, this.depth_min, this.depth_max, this.weight));
    }

    private ResourceKey<Biome> getBiome(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(name));
    }
}

