/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.cagerium.common;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.UUID;
import java.util.WeakHashMap;
import net.mehvahdjukaar.cagerium.Cagerium;
import net.mehvahdjukaar.cagerium.common.CageriumBlock;
import net.mehvahdjukaar.cagerium.common.MobData;
import net.mehvahdjukaar.cagerium.common.Tier;
import net.mehvahdjukaar.cagerium.mixins.SlimeInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CageriumBlockTile
extends BlockEntity {
    private final Tier tier;
    @Nullable
    private EntityType<?> entityType;
    private int tickCount;
    private byte upgradeLevel;
    private boolean burning;
    @Nullable
    private ItemStack groundItem;
    @Nullable
    private BlockState groundState;
    private final WeakHashMap<Integer, MobData> renderData = new WeakHashMap();
    private static final GameProfile DUMMY_PROFILE = new GameProfile(UUID.fromString("5b580441-d54a-38f1-1120-e3842a80632b"), "[cagerium]");

    public MobData getRenderData(int index) {
        return this.renderData.computeIfAbsent(index, e -> MobData.create(this.entityType, this.f_58857_));
    }

    public CageriumBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)Cagerium.TILE.get(), pos, state);
        Tier tier;
        Block block = state.m_60734_();
        if (block instanceof CageriumBlock) {
            CageriumBlock cb = (CageriumBlock)block;
            tier = cb.getTier();
        } else {
            tier = Tier.PASSIVE;
        }
        this.tier = tier;
    }

    public Tier getTier() {
        return this.tier;
    }

    public void saveToNbt(ItemStack stack) {
        if (this.entityType != null) {
            CompoundTag compound = new CompoundTag();
            this.saveCage(compound, false);
            stack.m_41700_("BlockEntityTag", (Tag)compound);
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.tickCount = compound.m_128451_("TickCount");
        this.burning = compound.m_128471_("Burning");
        this.upgradeLevel = compound.m_128445_("UpgradeLevel");
        if (compound.m_128441_("EntityType")) {
            ResourceLocation res = new ResourceLocation(compound.m_128461_("EntityType"));
            if (ForgeRegistries.ENTITIES.containsKey(res)) {
                this.entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(res);
            } else {
                Cagerium.LOGGER.warn("Found unknown entity type {} when loading cagerium block entity", (Object)res);
            }
        }
        if (compound.m_128441_("GroundItem")) {
            this.groundItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("GroundItem"));
            Item item = this.groundItem.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                this.groundState = bi.m_40614_().m_49966_();
            }
        }
        if (this.entityType == null) {
            this.renderData.clear();
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveCage(compound, true);
    }

    private void saveCage(CompoundTag compound, boolean saveItem) {
        compound.m_128405_("TickCount", this.tickCount);
        compound.m_128379_("Burning", this.burning);
        compound.m_128344_("UpgradeLevel", this.upgradeLevel);
        if (this.entityType != null) {
            compound.m_128359_("EntityType", this.entityType.getRegistryName().toString());
        }
        if (saveItem && this.groundItem != null) {
            compound.m_128365_("GroundItem", (Tag)this.groundItem.m_41739_(new CompoundTag()));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)CageriumBlock.FACING);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, CageriumBlockTile tile) {
        if (!pLevel.f_46443_ && tile.tickCount++ >= tile.getTickToDrop()) {
            tile.tickCount = 0;
            tile.tryDropLoot();
        }
    }

    private int getTickToDrop() {
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case Tier.PASSIVE -> (Integer)Cagerium.TICKS_TO_DROP_LOOT_0.get();
            case Tier.MOBS -> (Integer)Cagerium.TICKS_TO_DROP_LOOT_1.get();
            case Tier.BOSSES -> (Integer)Cagerium.TICKS_TO_DROP_LOOT_2.get();
        };
    }

    public boolean isEmpty() {
        return this.entityType == null;
    }

    public InteractionResult onInteract(Level world, BlockPos pos, Player player, InteractionHand hand, Direction direction) {
        BlockItem bi;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            EntityType type = spawnEggItem.m_43228_(stack.m_41783_());
            if (this.entityType == null) {
                if (this.tier.acceptsEntityType(type)) {
                    if (!world.f_46443_) {
                        this.entityType = type;
                        world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.PLAYERS, 1.0f, 1.2f);
                        this.m_6596_();
                        world.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
                player.m_5661_((Component)new TextComponent("Does not fit in here"), true);
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (this.upgradeLevel < 3 && type == this.entityType) {
                this.upgradeLevel = (byte)(this.upgradeLevel + 1);
                this.m_6596_();
                world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.PLAYERS, 1.0f, 1.2f);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                world.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.CONSUME_PARTIAL;
        }
        if (item == Cagerium.CAGE_KEY.get()) {
            if (this.entityType != null) {
                SpawnEggItem i = ForgeSpawnEggItem.fromEntityType(this.entityType);
                if (i != null) {
                    Block.m_152435_((Level)world, (BlockPos)pos, (Direction)direction, (ItemStack)i.m_7968_());
                    if (this.upgradeLevel != 0) {
                        this.upgradeLevel = (byte)(this.upgradeLevel - 1);
                    } else {
                        this.entityType = null;
                    }
                    this.m_6596_();
                    world.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                        player.m_21190_(hand);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            } else if (this.burning) {
                Block.m_152435_((Level)world, (BlockPos)pos, (Direction)direction, (ItemStack)((Item)Cagerium.FIRE_UPGRADE.get()).m_7968_());
                this.burning = false;
                this.m_6596_();
                world.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    player.m_21190_(hand);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        if (item == Cagerium.FIRE_UPGRADE.get() && !this.burning) {
            this.burning = true;
            this.m_6596_();
            world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.2f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            world.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (this.groundItem == null && item instanceof BlockItem && this.isValidBlockItem(pos, bi = (BlockItem)item)) {
            ItemStack s = stack.m_41777_();
            s.m_41764_(1);
            this.groundItem = s;
            if (!world.f_46443_) {
                this.m_6596_();
                world.m_5594_(null, pos, bi.m_40614_().m_49966_().m_60827_().m_56777_(), SoundSource.PLAYERS, 0.6f, 1.2f);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                world.m_7260_(pos, this.m_58900_(), this.m_58900_(), 3);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private boolean isValidBlockItem(BlockPos pos, BlockItem bi) {
        BlockState state = bi.m_40614_().m_49966_();
        return state.m_204336_(BlockTags.f_13035_) || state.m_60796_((BlockGetter)this.f_58857_, pos) && !state.m_155947_();
    }

    public void tryDropLoot() {
        Entity entity;
        if (this.entityType == null) {
            return;
        }
        MobData data = this.getMobData();
        if (data != null && (entity = data.getEntity()) instanceof LivingEntity) {
            IItemHandler itemHandler;
            LivingEntity livingEntity = (LivingEntity)entity;
            BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElse(null)) != null) {
                NonNullList<ItemStack> loot = this.createDropsList(livingEntity);
                loot.forEach(s -> ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)s, (boolean)false));
            }
        }
    }

    @Nullable
    public MobData getMobData() {
        if (this.entityType == null) {
            return null;
        }
        return MobData.getOrCreate(this.entityType, this.f_58857_, this.f_58858_);
    }

    private NonNullList<ItemStack> createDropsList(LivingEntity entity) {
        ResourceLocation type;
        LootTables tables;
        LootTable loottable;
        NonNullList drops = NonNullList.m_122779_();
        FakePlayer player = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.f_58857_), (GameProfile)DUMMY_PROFILE);
        if (this.burning) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42383_);
            EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44981_, 1));
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
            entity.m_20254_(1);
        } else {
            entity.m_20095_();
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if (entity instanceof SlimeInvoker) {
            SlimeInvoker s = (SlimeInvoker)entity;
            if (!(entity instanceof MagmaCube)) {
                s.invokeSetSize(0, false);
            }
        }
        if ((loottable = (tables = this.f_58857_.m_142572_().m_129898_()).m_79217_(new ResourceLocation((type = entity.m_6095_().getRegistryName()).m_135827_(), "cagerium/" + type.m_135815_()))) == LootTable.f_79105_) {
            loottable = tables.m_79217_(entity.m_5743_());
        }
        LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78977_(this.f_58857_.m_5822_()).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78972_(LootContextParams.f_81457_, (Object)(this.burning ? DamageSource.f_19307_ : DamageSource.f_19318_)).m_78984_(LootContextParams.f_81458_, (Object)player).m_78984_(LootContextParams.f_81459_, (Object)player).m_78972_(LootContextParams.f_81456_, (Object)player).m_78963_(player.m_36336_());
        LootContext ctx = builder.m_78975_(LootContextParamSets.f_81415_);
        for (int i = 0; i < this.upgradeLevel + 1; ++i) {
            if (entity instanceof WitherBoss) {
                drops.add((Object)Items.f_42686_.m_7968_());
                continue;
            }
            if (entity.m_6095_() == EntityType.f_20468_) {
                drops.add((Object)Items.f_42542_.m_7968_());
                continue;
            }
            drops.addAll((Collection)loottable.m_79129_(ctx));
        }
        entity.m_20254_(0);
        if (entity instanceof SlimeInvoker) {
            SlimeInvoker s = (SlimeInvoker)entity;
            s.invokeSetSize(3, false);
        }
        return drops;
    }

    public byte getUpgradeLevel() {
        return this.upgradeLevel;
    }

    public boolean isBurning() {
        return this.burning;
    }

    @Nullable
    public ItemStack getGroundStack() {
        return this.groundItem;
    }

    public BlockState getGroundState() {
        return this.groundState;
    }
}

