/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.cagerium.common;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.cagerium.Cagerium;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class CustomCageriumLootTables
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = Deserializers.m_78800_().create();
    private static Map<ResourceLocation, LootTable> TABLES = ImmutableMap.of();
    private final PredicateManager predicateManager;

    @Nullable
    public static LootTable getCustomLoot(EntityType<?> type) {
        return TABLES.get(type.getRegistryName());
    }

    public CustomCageriumLootTables(PredicateManager predicateManager) {
        super(GSON, "cagerium");
        this.predicateManager = predicateManager;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profile) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        jsons.forEach((id, j) -> {
            try {
                LootTable lootTable = (LootTable)GSON.fromJson(j, LootTable.class);
                builder.put(id, (Object)lootTable);
            }
            catch (Exception exception) {
                Cagerium.LOGGER.error("Couldn't parse loot table {}", id, (Object)exception);
            }
        });
        ImmutableMap immutablemap = builder.build();
        ValidationContext validationcontext = new ValidationContext(LootContextParamSets.f_81420_, arg_0 -> ((PredicateManager)this.predicateManager).m_79252_(arg_0), arg_0 -> ((ImmutableMap)immutablemap).get(arg_0));
        immutablemap.forEach((location, lootTable) -> LootTables.m_79202_((ValidationContext)validationcontext, (ResourceLocation)location, (LootTable)lootTable));
        validationcontext.m_79352_().forEach((s, s1) -> Cagerium.LOGGER.warn("Found validation problem in {}: {}", s, s1));
        TABLES = immutablemap;
    }
}

