/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.cagerium.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.cagerium.Cagerium;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SpawnEggShapedRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    final int width;
    final int height;
    final NonNullList<Ingredient> recipeItems;
    final ItemStack result;
    private final ResourceLocation id;
    final String group;

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public SpawnEggShapedRecipe(ResourceLocation pId, String pGroup, int pWidth, int pHeight, NonNullList<Ingredient> pRecipeItems, ItemStack pResult) {
        this.id = pId;
        this.group = pGroup;
        this.width = pWidth;
        this.height = pHeight;
        this.recipeItems = pRecipeItems;
        this.result = pResult;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Cagerium.UPGRADE_RECIPE.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth >= this.width && pHeight >= this.height;
    }

    public boolean matches(CraftingContainer pInv, Level pLevel) {
        for (int i = 0; i <= pInv.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= pInv.m_39346_() - this.height; ++j) {
                if (this.matches(pInv, i, j, true)) {
                    return true;
                }
                if (!this.matches(pInv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer pCraftingInventory, int pWidth, int pHeight, boolean pMirrored) {
        for (int i = 0; i < pCraftingInventory.m_39347_(); ++i) {
            for (int j = 0; j < pCraftingInventory.m_39346_(); ++j) {
                ItemStack itemInInv;
                int k = i - pWidth;
                int l = j - pHeight;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = pMirrored ? (Ingredient)this.recipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.recipeItems.get(k + l * this.width);
                }
                if (!((itemInInv = pCraftingInventory.m_8020_(i + j * pCraftingInventory.m_39347_())).m_41720_() instanceof SpawnEggItem ? !(Arrays.stream(ingredient.m_43908_()).findFirst().get().m_41720_() instanceof SpawnEggItem) : !ingredient.test(itemInInv))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer pInv) {
        ItemStack res = this.m_8043_().m_41777_();
        for (int i = 0; i < pInv.m_6643_(); ++i) {
            ItemStack stack = pInv.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof SpawnEggItem)) continue;
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            res.m_41784_().m_128359_("EntityType", spawnEggItem.m_43228_(stack.m_41783_()).getRegistryName().toString());
        }
        return res;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    static NonNullList<Ingredient> dissolvePattern(String[] pPattern, Map<String, Ingredient> pKeys, int pPatternWidth, int pPatternHeight) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(pPatternWidth * pPatternHeight), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(pKeys.keySet());
        set.remove(" ");
        for (int i = 0; i < pPattern.length; ++i) {
            for (int j = 0; j < pPattern[i].length(); ++j) {
                String s = pPattern[i].substring(j, j + 1);
                Ingredient ingredient = pKeys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + pPatternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... pToShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < pToShrink.length; ++i1) {
            String s = pToShrink[i1];
            i = Math.min(i, SpawnEggShapedRecipe.firstNonSpace(s));
            int j1 = SpawnEggShapedRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pToShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[pToShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = pToShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.m_43947_()).anyMatch(p_151273_ -> ForgeHooks.hasNoElements((Ingredient)p_151273_));
    }

    private static int firstNonSpace(String pEntry) {
        int i;
        for (i = 0; i < pEntry.length() && pEntry.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String pEntry) {
        int i;
        for (i = pEntry.length() - 1; i >= 0 && pEntry.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] patternFromJson(JsonArray pPatternArray) {
        String[] astring = new String[pPatternArray.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)pPatternArray.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    static Map<String, Ingredient> keyFromJson(JsonObject pKeyEntry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : pKeyEntry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack itemStackFromJson(JsonObject pStackObject) {
        return CraftingHelper.getItemStack((JsonObject)pStackObject, (boolean)true, (boolean)true);
    }

    public static Item itemFromJson(JsonObject pItemObject) {
        String s = GsonHelper.m_13906_((JsonObject)pItemObject, (String)"item");
        Item item = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + s);
        }
        return item;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SpawnEggShapedRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shaped");

        public SpawnEggShapedRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            Map<String, Ingredient> map = SpawnEggShapedRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"key"));
            String[] astring = SpawnEggShapedRecipe.shrink(SpawnEggShapedRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = SpawnEggShapedRecipe.dissolvePattern(astring, map, i, j);
            ItemStack itemstack = SpawnEggShapedRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            return new SpawnEggShapedRecipe(pRecipeId, s, i, j, nonnulllist, itemstack);
        }

        public SpawnEggShapedRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int i = pBuffer.m_130242_();
            int j = pBuffer.m_130242_();
            String s = pBuffer.m_130277_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack itemstack = pBuffer.m_130267_();
            return new SpawnEggShapedRecipe(pRecipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, SpawnEggShapedRecipe pRecipe) {
            pBuffer.m_130130_(pRecipe.width);
            pBuffer.m_130130_(pRecipe.height);
            pBuffer.m_130070_(pRecipe.group);
            for (Ingredient ingredient : pRecipe.recipeItems) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.result);
        }
    }
}

