/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.refinedmods.refinedstorage.block.CableBlock;
import edivad.extrastorage.loottable.AdvancedCrafterLootFunction;
import edivad.extrastorage.loottable.StorageBlockLootFunction;
import edivad.extrastorage.setup.Registration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;

public class LootTableGenerator
extends LootTableProvider {
    public LootTableGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(ESBlockLootTables::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
    }

    public String m_6055_() {
        return "Extra Storage Loot Tables";
    }

    private static class ESBlockLootTables
    extends BlockLoot {
        private ESBlockLootTables() {
        }

        protected void addTables() {
            Registration.CRAFTER_BLOCK.values().forEach(block -> this.genBlockItemLootTableWithFunction((Block)block.get(), (LootItemFunction.Builder)AdvancedCrafterLootFunction.builder()));
            Registration.ITEM_STORAGE_BLOCK.values().forEach(block -> this.genBlockItemLootTableWithFunction((Block)block.get(), (LootItemFunction.Builder)StorageBlockLootFunction.builder()));
            Registration.FLUID_STORAGE_BLOCK.values().forEach(block -> this.genBlockItemLootTableWithFunction((Block)block.get(), (LootItemFunction.Builder)StorageBlockLootFunction.builder()));
            this.m_124288_((Block)Registration.ADVANCED_EXPORTER.get());
            this.m_124288_((Block)Registration.ADVANCED_IMPORTER.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            ArrayList<Block> res = new ArrayList<Block>();
            res.addAll(Registration.CRAFTER_BLOCK.values().stream().map(RegistryObject::get).toList());
            res.addAll(Registration.ITEM_STORAGE_BLOCK.values().stream().map(RegistryObject::get).toList());
            res.addAll(Registration.FLUID_STORAGE_BLOCK.values().stream().map(RegistryObject::get).toList());
            res.addAll(Arrays.asList((CableBlock)Registration.ADVANCED_EXPORTER.get(), (CableBlock)Registration.ADVANCED_IMPORTER.get()));
            return res;
        }

        private void genBlockItemLootTableWithFunction(Block block, LootItemFunction.Builder builder) {
            this.m_124165_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_(builder)).m_6509_(ExplosionCondition.m_81661_())));
        }
    }
}

