/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.nodes;

import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.ItemStorageWrapperStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.StorageNetworkNode;
import edivad.extrastorage.blockentity.AdvancedStorageBlockEntity;
import edivad.extrastorage.items.storage.item.ItemStorageType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AdvancedStorageNetworkNode
extends StorageNetworkNode {
    public static final ResourceLocation BLOCK_256K_ID = new ResourceLocation("extrastorage", "block_256k");
    public static final ResourceLocation BLOCK_1024K_ID = new ResourceLocation("extrastorage", "block_1024k");
    public static final ResourceLocation BLOCK_4096K_ID = new ResourceLocation("extrastorage", "block_4096k");
    public static final ResourceLocation BLOCK_16384K_ID = new ResourceLocation("extrastorage", "block_16384k");
    private final ItemStorageType type;
    private IStorageDisk<ItemStack> storage;

    public AdvancedStorageNetworkNode(Level level, BlockPos pos, ItemStorageType type) {
        super(level, pos, null);
        this.type = type;
    }

    public int getEnergyUsage() {
        return 10 + this.type.ordinal() * 2;
    }

    public ResourceLocation getId() {
        return switch (this.type) {
            case ItemStorageType.TIER_5 -> BLOCK_256K_ID;
            case ItemStorageType.TIER_6 -> BLOCK_1024K_ID;
            case ItemStorageType.TIER_7 -> BLOCK_4096K_ID;
            case ItemStorageType.TIER_8 -> BLOCK_16384K_ID;
            default -> null;
        };
    }

    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        if (this.storage == null) {
            this.loadStorage(null);
        }
        storages.add((IStorage<ItemStack>)this.storage);
    }

    public void loadStorage(@Nullable Player owner) {
        IStorageDisk disk = API.instance().getStorageDiskManager((ServerLevel)this.level).get(this.getStorageId());
        if (disk == null) {
            disk = API.instance().createDefaultItemDisk((ServerLevel)this.level, this.type.getCapacity(), owner);
            API.instance().getStorageDiskManager((ServerLevel)this.level).set(this.getStorageId(), disk);
            API.instance().getStorageDiskManager((ServerLevel)this.level).markForSaving();
        }
        this.storage = new ItemStorageWrapperStorageDisk((StorageNetworkNode)this, disk);
    }

    public IStorageDisk<ItemStack> getStorage() {
        return this.storage;
    }

    public Component getTitle() {
        return new TranslatableComponent("block.extrastorage.block_" + this.type.getName());
    }

    public long getStored() {
        return (Long)AdvancedStorageBlockEntity.STORED.getValue();
    }

    public long getCapacity() {
        return this.type.getCapacity();
    }
}

