/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.setup;

import edivad.extrastorage.Main;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;

public class EventHandler {
    @SubscribeEvent
    public void handlePlayerLoggedInEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
        try {
            IModInfo modInfo = (IModInfo)ModList.get().getModFileById("extrastorage").getMods().get(0);
            String qualifier = modInfo.getVersion().getQualifier();
            if (qualifier != null && qualifier.contains("NONE")) {
                return;
            }
            VersionChecker.CheckResult versionRAW = VersionChecker.getResult((IModInfo)modInfo);
            if (versionRAW.target() == null) {
                return;
            }
            VersionChecker.Status result = versionRAW.status();
            LocalPlayer player = event.getPlayer();
            ArrayList<CallSite> messages = new ArrayList<CallSite>();
            if (result.equals((Object)VersionChecker.Status.OUTDATED) && versionRAW.changes().containsKey(versionRAW.target())) {
                String changes = (String)versionRAW.changes().get(versionRAW.target());
                messages.add((CallSite)((Object)(ChatFormatting.GREEN + "[Extra Storage] " + ChatFormatting.WHITE + "A new version is available (" + versionRAW.target() + "), please update!")));
                messages.add((CallSite)((Object)(ChatFormatting.YELLOW + "Changelog:")));
                Arrays.stream(changes.split("\n")).map(change -> ChatFormatting.WHITE + "- " + change).collect(Collectors.toCollection(() -> messages));
                if (versionRAW.changes().size() > 1) {
                    messages.add((CallSite)((Object)(ChatFormatting.WHITE + "- And more...")));
                }
            }
            messages.stream().map(TextComponent::new).forEach(message -> player.m_5661_((Component)message, false));
        }
        catch (Exception e) {
            Main.LOGGER.warn("Unable to check the version", (Throwable)e);
        }
    }
}

