/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.UncolossalChest;
import org.cyclops.colossalchests.inventory.container.ContainerUncolossalChest;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class BlockEntityUncolossalChest
extends CyclopsBlockEntity
implements MenuProvider,
LidBlockEntity {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityUncolossalChest.playSound(level, pos, blockState, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityUncolossalChest.playSound(level, pos, blockState, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState blockState, int p_155364_, int p_155365_) {
            BlockEntityUncolossalChest.this.signalOpenCount(level, pos, blockState, p_155364_, p_155365_);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ContainerUncolossalChest)) {
                return false;
            }
            Container container = ((ContainerUncolossalChest)player.f_36096_).getContainerInventory();
            return container == BlockEntityUncolossalChest.this.getInventory();
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private Component customName = null;
    private final SimpleInventory inventory = new SimpleInventory(5, 64){

        public void m_5856_(Player entityPlayer) {
            if (!entityPlayer.m_5833_()) {
                super.m_5856_(entityPlayer);
                BlockEntityUncolossalChest.this.startOpen(entityPlayer);
            }
        }

        public void m_5785_(Player entityPlayer) {
            if (!entityPlayer.m_5833_()) {
                super.m_5785_(entityPlayer);
                BlockEntityUncolossalChest.this.stopOpen(entityPlayer);
            }
        }
    };

    public BlockEntityUncolossalChest(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_UNCOLOSSAL_CHEST, blockPos, blockState);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> new InvWrapper((Container)this.inventory)));
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.inventory.read(tag.m_128469_("inventory"));
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag subTag = new CompoundTag();
        this.inventory.write(subTag);
        tag.m_128365_("inventory", (Tag)subTag);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    static void playSound(Level level, BlockPos pos, BlockState blockState, SoundEvent soundEvent) {
        level.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.2f + 1.15f);
    }

    public boolean m_7531_(int eventType, int value) {
        if (eventType == 1) {
            this.chestLidController.m_155377_(value > 0);
            return true;
        }
        return super.m_7531_(eventType, value);
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState blockState, int p_155336_, int value) {
        Block block = blockState.m_60734_();
        level.m_7696_(pos, block, 1, value);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState blockState, BlockEntityUncolossalChest blockEntity) {
        blockEntity.chestLidController.m_155374_();
    }

    public float m_6683_(float value) {
        return this.chestLidController.m_155375_(value);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component m_5446_() {
        return this.hasCustomName() ? this.customName : new TranslatableComponent("general.colossalchests.uncolossalchest");
    }

    public Direction getRotation() {
        if (this.m_58904_() == null) {
            return Direction.SOUTH;
        }
        BlockState blockState = this.m_58904_().m_8055_(this.m_58899_());
        if (blockState.m_60734_() != RegistryEntries.BLOCK_UNCOLOSSAL_CHEST) {
            return Direction.NORTH;
        }
        return (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)UncolossalChest.FACING, (Comparable)Direction.NORTH);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerUncolossalChest(id, playerInventory, (Container)this.getInventory());
    }
}

