/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.tracks;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class LazyIngredient
extends Ingredient {
    private static final LazyIngredient EMPTY = new LazyIngredient(Stream::empty);
    private final Supplier<Supplier<Ingredient.Value>[]> valueSupplier = () -> (Supplier[])((Stream)values.get()).toArray(Supplier[]::new);
    private Ingredient.Value[] internalValues;
    @Nullable
    private ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;

    public LazyIngredient(Supplier<Stream<Supplier<? extends Ingredient.Value>>> values) {
        super(Stream.empty());
    }

    private Ingredient.Value[] getValues() {
        if (this.internalValues == null) {
            this.internalValues = (Ingredient.Value[])Arrays.stream(this.valueSupplier.get()).map(Supplier::get).toArray(Ingredient.Value[]::new);
        }
        return this.internalValues;
    }

    public ItemStack[] m_43908_() {
        this.dissolve();
        return this.itemStacks;
    }

    private void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.getValues()).flatMap(entry -> entry.m_6223_().stream()).distinct().toArray(ItemStack[]::new);
        }
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        this.dissolve();
        if (this.itemStacks.length == 0) {
            return stack.m_41619_();
        }
        for (ItemStack itemStack : this.itemStacks) {
            if (!itemStack.m_150930_(stack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public IntList m_43931_() {
        if (this.stackingIds == null) {
            this.dissolve();
            this.stackingIds = new IntArrayList(this.itemStacks.length);
            for (ItemStack itemStack : this.itemStacks) {
                this.stackingIds.add(StackedContents.m_36496_((ItemStack)itemStack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public JsonElement m_43942_() {
        if (this.getValues().length == 1) {
            return this.getValues()[0].m_6544_();
        }
        JsonArray jsonArray = new JsonArray();
        for (Ingredient.Value value : this.getValues()) {
            jsonArray.add((JsonElement)value.m_6544_());
        }
        return jsonArray;
    }

    public boolean m_43947_() {
        return !(this.getValues().length != 0 || this.itemStacks != null && this.itemStacks.length != 0 || this.stackingIds != null && !this.stackingIds.isEmpty());
    }

    public static LazyIngredient fromValuesLazy(Supplier<Stream<Supplier<? extends Ingredient.Value>>> stream) {
        LazyIngredient ingredient = new LazyIngredient(stream);
        return ingredient;
    }

    public static LazyIngredient lazyOf() {
        return EMPTY;
    }

    @SafeVarargs
    public static LazyIngredient lazyOf(Supplier<ItemLike> ... items) {
        return LazyIngredient.lazyOf(Arrays.stream(items).map(e -> () -> LazyIngredient.lambda$lazyOf$5((Supplier)e)));
    }

    public static LazyIngredient lazyOf(Stream<Supplier<ItemStack>> stacks) {
        return LazyIngredient.fromValuesLazy(() -> stacks.filter(stack -> !((ItemStack)stack.get()).m_41619_()).map(e -> () -> LazyIngredient.lambda$lazyOf$8((Supplier)e)));
    }

    private static /* synthetic */ Ingredient.ItemValue lambda$lazyOf$8(Supplier e) {
        return new Ingredient.ItemValue((ItemStack)e.get());
    }

    private static /* synthetic */ ItemStack lambda$lazyOf$5(Supplier e) {
        return new ItemStack((ItemLike)e.get());
    }
}

