/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.tracks;

import com.google.common.collect.ImmutableSet;
import com.jozufozu.flywheel.core.PartialModel;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.CRTagGen;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.compat.tracks.CompatTrackBlockStateGenerator;
import com.railwayteam.railways.compat.tracks.GenericTrackCompat;
import com.railwayteam.railways.mixin.AccessorTrackMaterialFactory;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackMaterialFactory;
import com.simibubi.create.content.trains.track.TrackModel;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.ApiStatus;

public abstract class TrackCompatUtils {
    public static final Set<String> TRACK_COMPAT_MODS = ImmutableSet.of((Object)"hexcasting", (Object)"byg", (Object)"blue_skies", (Object)"twilightforest", (Object)"biomesoplenty");
    private static final CreateRegistrate REGISTRATE = Railways.registrate();

    public static boolean anyLoaded() {
        if (GenericTrackCompat.isDataGen()) {
            return true;
        }
        for (String mod : TRACK_COMPAT_MODS) {
            if (!Mods.valueOf((String)mod.toUpperCase((Locale)Locale.ROOT)).isLoaded) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean mixinIgnoreErrorForMissingItem(ResourceLocation resourceLocation) {
        if (resourceLocation.m_135827_().equals("railways")) {
            for (String compatMod : TRACK_COMPAT_MODS) {
                if (!resourceLocation.m_135815_().contains(compatMod)) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material) {
        return TrackCompatUtils.makeTrack(material, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((CompatTrackBlockStateGenerator)new CompatTrackBlockStateGenerator()).generate(arg_0, arg_1)));
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, boolean hideInCreativeTabs) {
        return TrackCompatUtils.makeTrack(material, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((CompatTrackBlockStateGenerator)new CompatTrackBlockStateGenerator()).generate(arg_0, arg_1)), (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}), p -> p, hideInCreativeTabs);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}));
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, onRegister, p -> p);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}), collectProperties);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, onRegister, collectProperties, false);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties, boolean hideInCreativeTabs) {
        String owningMod = material.id.m_135827_();
        String name = "track_" + owningMod + "_" + material.resourceName();
        CRTagGen.addOptionalTag(Railways.asResource(name), AllTags.AllBlockTags.TRACKS.tag, CommonTags.RELOCATION_NOT_SUPPORTED.forge, CommonTags.RELOCATION_NOT_SUPPORTED.fabric, BlockTags.f_144282_);
        if (material.trackType != CRTrackMaterials.CRTrackType.MONORAIL) {
            CRTagGen.addOptionalTag(Railways.asResource(name), AllTags.AllBlockTags.GIRDABLE_TRACKS.tag);
        }
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(name, arg_0 -> ((TrackMaterial)material).createBlock(arg_0)).initialProperties(Material.f_76278_).properties(p -> ((BlockBehaviour.Properties)collectProperties.apply((BlockBehaviour.Properties)p)).m_155949_(MaterialColor.f_76404_).m_60978_(0.8f).m_60918_(SoundType.f_56743_).m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate(blockstateGen).lang(material.langName + " Train Track").onRegister(onRegister)).onRegister(CreateRegistrate.blockModel(() -> TrackModel::new))).onRegister(CRTrackMaterials::addToBlockEntityType)).item(TrackBlockItem::new).properties(p -> {
            if (hideInCreativeTabs) {
                p.m_41491_(null);
            }
            return p;
        }).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{new ResourceLocation(owningMod, "item/track/track_" + material.resourceName())})).build()).register();
    }

    public static TrackMaterial buildCompatModels(TrackMaterialFactory factory) {
        String namespace = ((AccessorTrackMaterialFactory)factory).getId().m_135827_();
        String path = ((AccessorTrackMaterialFactory)factory).getId().m_135815_();
        String prefix = "block/track/compat/" + namespace + "/" + path + "/";
        return factory.customModels(() -> () -> new PartialModel(Railways.asResource(prefix + "tie")), () -> () -> new PartialModel(Railways.asResource(prefix + "segment_left")), () -> () -> new PartialModel(Railways.asResource(prefix + "segment_right"))).build();
    }
}

