/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.railwayteam.railways.content.conductor.ClientHandler;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.CameraMovePacket;
import com.railwayteam.railways.util.packet.DismountCameraPacket;
import com.railwayteam.railways.util.packet.SpyConductorInteractPacket;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ConductorPossessionController {
    @OnlyIn(value=Dist.CLIENT)
    private static ClientChunkCache.Storage cameraStorage;
    private static boolean wasUpPressed;
    private static boolean wasDownPressed;
    private static boolean wasLeftPressed;
    private static boolean wasRightPressed;
    private static boolean wasJumpPressed;
    private static boolean wasSprintPressed;
    private static boolean wasMounted;
    private static final boolean[] wasMouseClicked;
    private static final boolean[] wasMousePressed;
    private static boolean wasUsingBefore;
    private static int ticksSincePacket;
    private static int positionReminder;

    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(Minecraft mc, boolean start) {
        Entity cameraEntity = mc.f_91075_;
        if (cameraEntity instanceof ConductorEntity) {
            ConductorEntity cam = (ConductorEntity)cameraEntity;
            wasMounted = true;
            Options options = mc.f_91066_;
            if (start) {
                wasUpPressed = options.f_92085_.m_90857_();
                if (wasUpPressed) {
                    options.f_92085_.m_7249_(false);
                }
                if (wasDownPressed = options.f_92087_.m_90857_()) {
                    options.f_92087_.m_7249_(false);
                }
                if (wasLeftPressed = options.f_92086_.m_90857_()) {
                    options.f_92086_.m_7249_(false);
                }
                if (wasRightPressed = options.f_92088_.m_90857_()) {
                    options.f_92088_.m_7249_(false);
                }
                if (wasJumpPressed = options.f_92089_.m_90857_()) {
                    options.f_92089_.m_7249_(false);
                }
                wasSprintPressed = options.f_92091_.m_90857_();
                if (options.f_92090_.m_90857_()) {
                    ConductorPossessionController.dismount();
                    options.f_92090_.m_7249_(false);
                }
            } else {
                boolean bl5;
                if (wasUpPressed) {
                    options.f_92085_.m_7249_(true);
                }
                if (wasDownPressed) {
                    options.f_92087_.m_7249_(true);
                }
                if (wasLeftPressed) {
                    options.f_92086_.m_7249_(true);
                }
                if (wasRightPressed) {
                    options.f_92088_.m_7249_(true);
                }
                if (wasJumpPressed) {
                    options.f_92089_.m_7249_(true);
                }
                LocalPlayer player = mc.f_91074_;
                double yRotChange = player.m_146908_() - player.f_108598_;
                double xRotChange = player.m_146909_() - player.f_108599_;
                if (yRotChange != 0.0 || xRotChange != 0.0 || ++ticksSincePacket > 10) {
                    ticksSincePacket = 0;
                    player.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(player.m_146908_(), player.m_146909_(), player.m_20096_()));
                    player.f_108617_.m_104955_((Packet)new ServerboundPlayerInputPacket(0.0f, 0.0f, false, false));
                }
                double d = cam.m_20185_() - cam.xLast;
                double e = cam.m_20186_() - cam.yLast;
                double f = cam.m_20189_() - cam.zLast;
                double g = (double)cam.m_146908_() - cam.yRotLast;
                double h = (double)cam.m_146909_() - cam.xRotLast;
                boolean bl3 = Mth.m_211592_((double)d, (double)e, (double)f) > Mth.m_144952_((double)2.0E-4) || ++positionReminder >= 20;
                boolean bl = bl5 = g != 0.0 || h != 0.0;
                if (bl3 || bl5) {
                    CRPackets.PACKETS.send(new CameraMovePacket(cam, new ServerboundMovePlayerPacket.PosRot(cam.m_20185_(), cam.m_20186_(), cam.m_20189_(), cam.m_146908_(), cam.m_146909_(), cam.m_20096_())));
                }
            }
        } else if (wasMounted) {
            wasMounted = false;
            ConductorPossessionController.dismount();
            mc.f_91060_.m_109818_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onHandleKeybinds(Minecraft mc, boolean start) {
        Entity cameraEntity = mc.f_91075_;
        if (cameraEntity instanceof ConductorEntity) {
            ConductorEntity cam = (ConductorEntity)cameraEntity;
            wasMounted = true;
            Options options = mc.f_91066_;
            if (start) {
                Arrays.fill(wasMouseClicked, false);
                Arrays.fill(wasMousePressed, false);
                while (options.f_92096_.m_90859_()) {
                    ConductorPossessionController.wasMouseClicked[0] = true;
                }
                while (options.f_92095_.m_90859_()) {
                    ConductorPossessionController.wasMouseClicked[1] = true;
                }
                while (options.f_92097_.m_90859_()) {
                    ConductorPossessionController.wasMouseClicked[2] = true;
                }
                ConductorPossessionController.wasMousePressed[0] = options.f_92096_.m_90857_();
                if (ConductorPossessionController.wasMousePressed[0]) {
                    options.f_92096_.m_7249_(false);
                }
                if (ConductorPossessionController.wasMousePressed[1] = options.f_92095_.m_90857_()) {
                    options.f_92095_.m_7249_(false);
                }
                if (ConductorPossessionController.wasMousePressed[2] = options.f_92097_.m_90857_()) {
                    options.f_92097_.m_7249_(false);
                }
            } else {
                if (wasMousePressed[0]) {
                    options.f_92096_.m_7249_(true);
                }
                if (wasMousePressed[1]) {
                    options.f_92095_.m_7249_(true);
                    if (!wasUsingBefore) {
                        BlockHitResult blockHitResult;
                        wasUsingBefore = true;
                        HitResult hitresult = mc.f_91077_;
                        if (hitresult != null && hitresult.m_6662_() == HitResult.Type.BLOCK && mc.f_91073_ != null && hitresult instanceof BlockHitResult && ConductorEntity.canSpyInteract(mc.f_91073_.m_8055_((blockHitResult = (BlockHitResult)hitresult).m_82425_()))) {
                            CRPackets.PACKETS.send(new SpyConductorInteractPacket(blockHitResult.m_82425_()));
                        }
                    }
                } else {
                    wasUsingBefore = false;
                }
                if (wasMousePressed[2]) {
                    options.f_92097_.m_7249_(true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void dismount() {
        CRPackets.PACKETS.send(new DismountCameraPacket());
        wasMounted = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ClientChunkCache.Storage getCameraStorage() {
        return cameraStorage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setCameraStorage(ClientChunkCache.Storage newStorage) {
        cameraStorage = newStorage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setRenderPosition(Entity entity) {
        if (entity instanceof ConductorEntity) {
            SectionPos cameraPos = SectionPos.m_123194_((Entity)entity);
            ConductorPossessionController.cameraStorage.f_104469_ = cameraPos.m_123170_();
            ConductorPossessionController.cameraStorage.f_104470_ = cameraPos.m_123222_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tryUpdatePossession(ConductorEntity conductorEntity) {
        if (ClientHandler.getPlayerMountedOnCamera() == conductorEntity) {
            ConductorPossessionController.setRenderPosition((Entity)conductorEntity);
        }
    }

    public static boolean isPossessingConductor(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (player.f_19853_.f_46443_) {
            return ClientHandler.isPlayerMountedOnCamera();
        }
        return ((ServerPlayer)player).m_8954_() instanceof ConductorEntity;
    }

    @Nullable
    public static ConductorEntity getPossessingConductor(Entity entity) {
        ConductorEntity ce;
        if (!(entity instanceof Player)) {
            return null;
        }
        Player player = (Player)entity;
        if (player.f_19853_.f_46443_) {
            return ClientHandler.getPlayerMountedOnCamera();
        }
        Entity entity2 = ((ServerPlayer)player).m_8954_();
        return entity2 instanceof ConductorEntity ? (ce = (ConductorEntity)entity2) : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasUpPressed() {
        return wasUpPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasDownPressed() {
        return wasDownPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasLeftPressed() {
        return wasLeftPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasRightPressed() {
        return wasRightPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasSprintPressed() {
        return wasSprintPressed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasJumpPressed() {
        return wasJumpPressed;
    }

    static {
        wasMouseClicked = new boolean[3];
        wasMousePressed = new boolean[3];
        ticksSincePacket = 0;
        positionReminder = 0;
    }
}

