/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.remote_lens;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.utility.Components;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteLensItem
extends Item {
    public RemoteLensItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_("SelectedConductor")) {
            UUID conductorId = tag.m_128342_("SelectedConductor");
            tooltip.add((Component)Components.translatable((String)"railways.whistle.tool.bound").m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.conductor_id", conductorId.toString().substring(0, 5)));
            tooltip.add((Component)Components.translatable((String)"railways.remote_lens.tool.bound_usage"));
        } else {
            tooltip.add((Component)Components.translatable((String)"railways.remote_lens.tool.not_bound").m_130940_(ChatFormatting.DARK_RED));
        }
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        ConductorEntity conductor;
        if (pPlayer.f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (pInteractionTarget instanceof ConductorEntity && (conductor = (ConductorEntity)pInteractionTarget).getJob() == ConductorEntity.Job.SPY) {
            CompoundTag stackTag = pStack.m_41784_();
            stackTag.m_128362_("SelectedConductor", conductor.m_142081_());
            pPlayer.m_5661_((Component)Components.translatable((String)"railways.remote_lens.set"), true);
            pStack.m_41751_(stackTag);
            pPlayer.m_21008_(pUsedHand, pStack);
            AllSoundEvents.PECULIAR_BELL_USE.play(pPlayer.f_19853_, null, conductor.m_20185_(), conductor.m_20186_(), conductor.m_20189_(), 0.5f, 1.1f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.FAIL;
        }
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ConductorEntity conductor;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CompoundTag stackTag = stack.m_41783_();
                if (stackTag == null || !stackTag.m_128403_("SelectedConductor")) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                UUID conductorId = stackTag.m_128342_("SelectedConductor");
                if (player.m_6144_()) {
                    stack.m_41749_("SelectedConductor");
                    AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)player.m_142538_(), 0.5f, 1.1f);
                    player.m_5661_((Component)Components.translatable((String)"railways.remote_lens.clear"), true);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                Entity entity = serverLevel.m_8791_(conductorId);
                if (entity instanceof ConductorEntity && (conductor = (ConductorEntity)entity).getJob() == ConductorEntity.Job.SPY) {
                    return conductor.startViewing(serverPlayer) ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19100_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }
}

