/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.selection_menu;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.content.custom_bogeys.selection_menu.RadialBogeyCategoryMenu;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.EntityUtils;
import com.railwayteam.railways.util.Utils;
import com.railwayteam.railways.util.packet.BogeyStyleSelectionPacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.AllKeys;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Pair;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BogeyCategoryHandlerClient {
    static final ResourceLocation FAVORITES_CATEGORY = Railways.asResource("favorites_category");
    static final ResourceLocation MANAGE_FAVORITES_CATEGORY = Railways.asResource("manage_favorites_category");
    private static final Map<ResourceLocation, NonNullSupplier<? extends ItemLike>> STYLE_CATEGORIES = new HashMap<ResourceLocation, NonNullSupplier<? extends ItemLike>>();
    private static final List<ResourceLocation> STYLE_CATEGORY_ORDER = new ArrayList<ResourceLocation>();
    static int COOLDOWN = 0;
    @Nullable
    private static BogeyStyle selectedStyle;
    @Nullable
    private static BogeySizes.BogeySize selectedSize;
    @Nullable
    private static List<BogeyStyle> favorites;
    public static final Map<Pair<BogeyStyle, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable BogeySizes.BogeySize>, ResourceLocation> ICONS;

    public static ResourceLocation getCategoryId(int i) {
        if (i == 0) {
            return FAVORITES_CATEGORY;
        }
        return STYLE_CATEGORY_ORDER.get(i - 1);
    }

    public static int categoryCount() {
        return STYLE_CATEGORIES.size() + 1;
    }

    public static NonNullSupplier<? extends ItemLike> getCategoryIcon(ResourceLocation id) {
        if (id == FAVORITES_CATEGORY) {
            return () -> Items.f_42437_;
        }
        return STYLE_CATEGORIES.get(id);
    }

    public static NonNullSupplier<? extends ItemLike> getCategoryIcon(int i) {
        return BogeyCategoryHandlerClient.getCategoryIcon(BogeyCategoryHandlerClient.getCategoryId(i));
    }

    public static Map<ResourceLocation, BogeyStyle> getStylesInCategory(int i) {
        return BogeyCategoryHandlerClient.getStylesInCategory(BogeyCategoryHandlerClient.getCategoryId(i));
    }

    public static Map<ResourceLocation, BogeyStyle> getStylesInCategory(ResourceLocation id) {
        if (id == MANAGE_FAVORITES_CATEGORY || id == FAVORITES_CATEGORY) {
            HashMap<ResourceLocation, BogeyStyle> map = new HashMap<ResourceLocation, BogeyStyle>();
            for (BogeyStyle style : BogeyCategoryHandlerClient.getFavorites()) {
                map.put(style.name, style);
            }
            return map;
        }
        if (Mods.EXTENDEDBOGEYS.isLoaded) {
            if (id.equals((Object)Railways.asResource("extendedbogeys"))) {
                HashMap<ResourceLocation, BogeyStyle> EB = new HashMap<ResourceLocation, BogeyStyle>((Map)AllBogeyStyles.CYCLE_GROUPS.get(Create.asResource((String)"standard")));
                EB.remove(Create.asResource((String)"standard"));
                EB.remove(Railways.asResource("invisible"));
                return EB;
            }
            if (id.equals((Object)Create.asResource((String)"standard"))) {
                HashMap<ResourceLocation, BogeyStyle> noEB = new HashMap<ResourceLocation, BogeyStyle>((Map)AllBogeyStyles.CYCLE_GROUPS.get(Create.asResource((String)"standard")));
                noEB.remove(new ResourceLocation("extendedbogeys", "single_axle"));
                noEB.remove(new ResourceLocation("extendedbogeys", "double_axle"));
                noEB.remove(new ResourceLocation("extendedbogeys", "triple_axle"));
                return noEB;
            }
        }
        return AllBogeyStyles.CYCLE_GROUPS.getOrDefault(id, new HashMap());
    }

    public static ResourceLocation getStyleId(ResourceLocation categoryId, int styleIdx) {
        if (categoryId == MANAGE_FAVORITES_CATEGORY) {
            return BogeyCategoryHandlerClient.getFavorites().get((int)styleIdx).name;
        }
        return ((ResourceLocation[])BogeyCategoryHandlerClient.getStylesInCategory(categoryId).keySet().toArray(ResourceLocation[]::new))[styleIdx];
    }

    public static BogeyStyle getStyle(int categoryIdx, int styleIdx) {
        return BogeyCategoryHandlerClient.getStyle(BogeyCategoryHandlerClient.getCategoryId(categoryIdx), styleIdx);
    }

    public static BogeyStyle getStyle(ResourceLocation categoryId, int styleIdx) {
        int offset = 0;
        for (int i = 0; i < BogeyCategoryHandlerClient.styleCount(categoryId); ++i) {
            BogeyStyle style = BogeyCategoryHandlerClient.getStylesInCategory(categoryId).get(BogeyCategoryHandlerClient.getStyleId(categoryId, i));
            if (!BogeyCategoryHandlerClient.showIndividualSizes(style)) {
                if (i + offset != styleIdx) continue;
                return style;
            }
            for (int sizeIdx = 0; sizeIdx < style.validSizes().size(); ++sizeIdx) {
                if (i + offset + sizeIdx != styleIdx) continue;
                return style;
            }
            offset += style.validSizes().size() - 1;
        }
        if (Utils.isDevEnv()) {
            Railways.LOGGER.error("getStyle failed! category: " + categoryId + ", styleIdx: " + styleIdx);
        }
        return BogeyCategoryHandlerClient.getStylesInCategory(categoryId).get(BogeyCategoryHandlerClient.getStyleId(categoryId, styleIdx));
    }

    @Nullable
    public static BogeySizes.BogeySize getSize(ResourceLocation categoryId, int styleIdx) {
        int offset = 0;
        for (int i = 0; i < BogeyCategoryHandlerClient.styleCount(categoryId); ++i) {
            BogeyStyle style = BogeyCategoryHandlerClient.getStylesInCategory(categoryId).get(BogeyCategoryHandlerClient.getStyleId(categoryId, i));
            if (!BogeyCategoryHandlerClient.showIndividualSizes(style)) {
                if (i + offset != styleIdx) continue;
                return null;
            }
            int sizeIdx = 0;
            for (BogeySizes.BogeySize size : style.validSizes()) {
                if (i + offset + sizeIdx == styleIdx) {
                    return size;
                }
                ++sizeIdx;
            }
            offset += style.validSizes().size() - 1;
        }
        if (Utils.isDevEnv()) {
            Railways.LOGGER.error("getStyle failed! category: " + categoryId + ", styleIdx: " + styleIdx);
        }
        return null;
    }

    public static int styleCount(ResourceLocation categoryId) {
        if (categoryId == MANAGE_FAVORITES_CATEGORY) {
            return BogeyCategoryHandlerClient.styleAndSizeCount(BogeyCategoryHandlerClient.getFavorites());
        }
        return BogeyCategoryHandlerClient.styleAndSizeCount(BogeyCategoryHandlerClient.getStylesInCategory(categoryId).values());
    }

    private static int styleAndSizeCount(Collection<BogeyStyle> styles) {
        int count = 0;
        for (BogeyStyle style : styles) {
            count += BogeyCategoryHandlerClient.showIndividualSizes(style) ? style.validSizes().size() : 1;
        }
        return count;
    }

    public static void registerStyleCategory(String name, NonNullSupplier<? extends ItemLike> icon) {
        BogeyCategoryHandlerClient.registerStyleCategory(Railways.asResource(name), icon);
    }

    public static void registerStyleCategory(ResourceLocation id, NonNullSupplier<? extends ItemLike> icon) {
        STYLE_CATEGORIES.put(id, icon);
        STYLE_CATEGORY_ORDER.add(id);
    }

    @Nullable
    public static BogeyStyle getSelectedStyle() {
        return selectedStyle;
    }

    @Nullable
    public static BogeySizes.BogeySize getSelectedSize() {
        return selectedSize;
    }

    static void setSelectedStyle(@Nullable BogeyStyle style, @Nullable BogeySizes.BogeySize size) {
        if (selectedStyle == style && selectedSize == size) {
            return;
        }
        selectedStyle = style;
        selectedSize = size;
        if (style == null) {
            style = AllBogeyStyles.STANDARD;
        }
        CRPackets.PACKETS.send(new BogeyStyleSelectionPacket(style, size));
    }

    @NotNull
    static List<BogeyStyle> getFavorites() {
        if (favorites == null) {
            BogeyCategoryHandlerClient.loadFavorites();
        }
        return favorites;
    }

    static void optimizeFavorites() {
        ArrayList<BogeyStyle> newFavorites = new ArrayList<BogeyStyle>();
        for (BogeyStyle style : BogeyCategoryHandlerClient.getFavorites()) {
            if (newFavorites.contains(style)) continue;
            newFavorites.add(style);
        }
        favorites = newFavorites;
        BogeyCategoryHandlerClient.saveFavorites();
    }

    public static void loadFavorites() {
        favorites = new ArrayList<BogeyStyle>();
        try {
            Minecraft mc = Minecraft.m_91087_();
            File file = new File(mc.f_91069_, "snr_favorite_styles.nbt");
            CompoundTag tag = NbtIo.m_128953_((File)file);
            if (tag == null) {
                return;
            }
            if (tag.m_128425_("Favorites", 9)) {
                ListTag favoritesList = tag.m_128437_("Favorites", 8);
                if (favorites == null) {
                    favorites = new ArrayList<BogeyStyle>();
                }
                favorites.clear();
                for (Tag favoriteTag : favoritesList) {
                    StringTag stringTag;
                    ResourceLocation loc;
                    if (!(favoriteTag instanceof StringTag) || (loc = ResourceLocation.m_135820_((String)(stringTag = (StringTag)favoriteTag).m_7916_())) == null || !AllBogeyStyles.BOGEY_STYLES.containsKey(loc)) continue;
                    favorites.add((BogeyStyle)AllBogeyStyles.BOGEY_STYLES.get(loc));
                }
            }
            BogeyCategoryHandlerClient.optimizeFavorites();
        }
        catch (Exception e) {
            Railways.LOGGER.error("Failed to load favorite styles", (Throwable)e);
        }
    }

    public static boolean showIndividualSizes(BogeyStyle style) {
        return style.name.m_135827_().equals("extendedbogeys") && style.name.m_135815_().equals("double_axle");
    }

    public static void saveFavorites() {
        if (favorites == null) {
            return;
        }
        try {
            CompoundTag tag = new CompoundTag();
            ListTag listTag = new ListTag();
            for (BogeyStyle style : favorites) {
                listTag.add((Object)StringTag.m_129297_((String)style.name.toString()));
            }
            tag.m_128365_("Favorites", (Tag)listTag);
            NbtIo.m_128955_((CompoundTag)tag, (File)new File(Minecraft.m_91087_().f_91069_, "snr_favorite_styles.nbt"));
        }
        catch (Exception e) {
            Railways.LOGGER.error("Failed to save favorite styles", (Throwable)e);
        }
    }

    public static void clientTick() {
        if (COOLDOWN > 0 && !AllKeys.TOOL_MENU.isPressed()) {
            --COOLDOWN;
        }
    }

    public static void onKeyInput(int key, boolean pressed) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91072_ == null || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        if (key != AllKeys.TOOL_MENU.getBoundCode() || !pressed) {
            return;
        }
        if (COOLDOWN > 0) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Level level = player.f_19853_;
        if (!EntityUtils.isHolding((Player)player, arg_0 -> ((BlockEntry)AllBlocks.RAILWAY_CASING).isIn(arg_0))) {
            return;
        }
        ScreenOpener.open((Screen)new RadialBogeyCategoryMenu(RadialBogeyCategoryMenu.State.PICK_CATEGORY));
    }

    public static void addIcon(BogeyStyle style, String name) {
        ICONS.put((Pair<BogeyStyle, BogeySizes.BogeySize>)Pair.of((Object)style, null), Railways.asResource("textures/gui/bogey_icons/" + name + "_icon.png"));
    }

    public static void addIcon(BogeyStyle style, BogeySizes.BogeySize size, String name) {
        if (!BogeyCategoryHandlerClient.showIndividualSizes(style)) {
            if (Utils.isDevEnv()) {
                throw new IllegalStateException("Cannot add sized icon for style that does not show individual sizes");
            }
            BogeyCategoryHandlerClient.addIcon(style, name);
            return;
        }
        ICONS.put((Pair<BogeyStyle, BogeySizes.BogeySize>)Pair.of((Object)style, (Object)size), Railways.asResource("textures/gui/bogey_icons/" + name + "_icon.png"));
    }

    public static boolean hasIcon(BogeyStyle style, BogeySizes.BogeySize size) {
        return BogeyCategoryHandlerClient.showIndividualSizes(style) && ICONS.containsKey(Pair.of((Object)style, (Object)size)) || ICONS.containsKey(Pair.of((Object)style, null));
    }

    public static ResourceLocation getIcon(BogeyStyle style, BogeySizes.BogeySize size) {
        if (BogeyCategoryHandlerClient.showIndividualSizes(style) && ICONS.containsKey(Pair.of((Object)style, (Object)size))) {
            return ICONS.get(Pair.of((Object)style, (Object)size));
        }
        return ICONS.get(Pair.of((Object)style, null));
    }

    static {
        favorites = null;
        ICONS = new HashMap<Pair<BogeyStyle, BogeySizes.BogeySize>, ResourceLocation>();
        for (BogeyStyle style : AllBogeyStyles.BOGEY_STYLES.values()) {
            if (style.name.m_135827_().equals("railways")) {
                BogeyCategoryHandlerClient.addIcon(style, style.name.m_135815_());
            } else if (Mods.EXTENDEDBOGEYS.isLoaded && style.name.m_135827_().equals("extendedbogeys")) {
                BogeyCategoryHandlerClient.addIcon(style, "eb_" + style.name.m_135815_());
            }
            BogeyCategoryHandlerClient.addIcon(AllBogeyStyles.STANDARD, "default");
        }
    }
}

