/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.monorail;

import com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackVoxelShapes;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.AllShapes;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MonorailTrackBlockOutline {
    public static final VoxelShape MONORAIL_LONG_CROSS = Shapes.m_83110_((VoxelShape)MonorailTrackVoxelShapes.longOrthogonalZ(), (VoxelShape)MonorailTrackVoxelShapes.longOrthogonalX());
    public static final VoxelShape MONORAIL_LONG_ORTHO = MonorailTrackVoxelShapes.longOrthogonalZ();
    public static final VoxelShape MONORAIL_LONG_ORTHO_OFFSET = MonorailTrackVoxelShapes.longOrthogonalZOffset();
    public static final Map<VoxelShape, VoxelShape> TRACK_TO_MONORAIL = Map.of(AllShapes.TRACK_ORTHO.get(Direction.EAST), CRShapes.MONORAIL_TRACK_ORTHO.get(Direction.EAST), AllShapes.TRACK_ORTHO.get(Direction.SOUTH), CRShapes.MONORAIL_TRACK_ORTHO.get(Direction.SOUTH), AllShapes.TRACK_CROSS, CRShapes.MONORAIL_TRACK_CROSS);

    public static VoxelShape convert(Object o, boolean monorail) {
        if (o instanceof VoxelShape) {
            VoxelShape shape = (VoxelShape)o;
            return MonorailTrackBlockOutline.convert(shape, monorail);
        }
        throw new IllegalArgumentException("object is not a VoxelShape");
    }

    public static VoxelShape convert(VoxelShape trackShape, boolean monorail) {
        return monorail ? TRACK_TO_MONORAIL.getOrDefault(trackShape, trackShape) : trackShape;
    }
}

