/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.multiloader.forge;

import com.railwayteam.railways.multiloader.PlayerSelection;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;

public class PlayerSelectionImpl
extends PlayerSelection {
    final PacketDistributor.PacketTarget target;

    private PlayerSelectionImpl(PacketDistributor.PacketTarget target) {
        this.target = target;
    }

    @Override
    public void accept(ResourceLocation id, FriendlyByteBuf buffer) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(id, buffer);
        this.target.send((Packet)packet);
    }

    public static PlayerSelection all() {
        return new PlayerSelectionImpl(PacketDistributor.ALL.noArg());
    }

    public static PlayerSelection of(ServerPlayer player) {
        return new PlayerSelectionImpl(PacketDistributor.PLAYER.with(() -> player));
    }

    public static PlayerSelection tracking(Entity entity) {
        return new PlayerSelectionImpl(PacketDistributor.TRACKING_ENTITY.with(() -> entity));
    }

    public static PlayerSelection tracking(BlockEntity be) {
        LevelChunk chunk = be.m_58904_().m_46745_(be.m_58899_());
        return new PlayerSelectionImpl(PacketDistributor.TRACKING_CHUNK.with(() -> chunk));
    }

    public static PlayerSelection tracking(ServerLevel level, BlockPos pos) {
        LevelChunk chunk = level.m_46745_(pos);
        return new PlayerSelectionImpl(PacketDistributor.TRACKING_CHUNK.with(() -> chunk));
    }

    public static PlayerSelection trackingAndSelf(ServerPlayer player) {
        return new PlayerSelectionImpl(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
    }
}

