/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.content.custom_bogeys.CRBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.CategoryIcon;
import com.railwayteam.railways.content.custom_bogeys.invisible.InvisibleBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.monobogey.MonoBogeyRenderer;
import com.railwayteam.railways.content.custom_bogeys.selection_menu.BogeyCategoryHandlerClient;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.utility.Components;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CRBogeyStyles {
    public static final BogeyStyle MONOBOGEY = CRBogeyStyles.create("monobogey", "monobogey").displayName((Component)Components.translatable((String)"railways.bogeys.styles.monobogey")).size(BogeySizes.SMALL, () -> MonoBogeyRenderer.SmallMonoBogeyRenderer::new, CRBlocks.MONO_BOGEY).build();
    public static final BogeyStyle INVISIBLE = CRBogeyStyles.create("invisible", Create.asResource((String)"standard")).displayName((Component)Components.translatable((String)"railways.bogeys.styles.invisible")).size(BogeySizes.SMALL, () -> InvisibleBogeyRenderer::new, CRBlocks.INVISIBLE_BOGEY).contactParticle((ParticleOptions)new CubeParticleData()).build();
    public static final String SINGLEAXLE_CYCLE_GROUP = "singleaxles";
    public static final String DOUBLEAXLE_CYCLE_GROUP = "doubleaxles";
    public static final String TRIPLEAXLE_CYCLE_GROUP = "tripleaxles";
    public static final BogeyStyle SINGLEAXLE = CRBogeyStyles.create("singleaxle", "singleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.SingleaxleBogeyRenderer::new, CRBlocks.SINGLEAXLE_BOGEY).build();
    public static final BogeyStyle LEAFSPRING = CRBogeyStyles.create("leafspring", "singleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.LeafspringBogeyRenderer::new, CRBlocks.SINGLEAXLE_BOGEY).build();
    public static final BogeyStyle COILSPRING = CRBogeyStyles.create("coilspring", "singleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.CoilspringBogeyRenderer::new, CRBlocks.SINGLEAXLE_BOGEY).build();
    public static final BogeyStyle FREIGHT = CRBogeyStyles.create("freight", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.FreightBogeyRenderer::new, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle ARCHBAR = CRBogeyStyles.create("archbar", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.ArchbarBogeyRenderer::new, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle PASSENGER = CRBogeyStyles.create("passenger", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.PassengerBogeyRenderer::new, CRBlocks.DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle MODERN = CRBogeyStyles.create("modern", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.ModernBogeyRenderer::new, CRBlocks.DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle BLOMBERG = CRBogeyStyles.create("blomberg", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.BlombergBogeyRenderer::new, CRBlocks.DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle Y25 = CRBogeyStyles.create("y25", "doubleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.Y25BogeyRenderer::new, CRBlocks.LARGE_PLATFORM_DOUBLEAXLE_BOGEY).build();
    public static final BogeyStyle HEAVYWEIGHT = CRBogeyStyles.create("heavyweight", "tripleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.HeavyweightBogeyRenderer::new, CRBlocks.TRIPLEAXLE_BOGEY).build();
    public static final BogeyStyle RADIAL = CRBogeyStyles.create("radial", "tripleaxles").size(BogeySizes.SMALL, () -> CRBogeyRenderer.RadialBogeyRenderer::new, CRBlocks.TRIPLEAXLE_BOGEY).build();

    public static AllBogeyStyles.BogeyStyleBuilder create(String name, String cycleGroup) {
        return CRBogeyStyles.create(Railways.asResource(name), Railways.asResource(cycleGroup)).displayName((Component)Components.translatable((String)("railways.bogeys.styles." + name)));
    }

    public static AllBogeyStyles.BogeyStyleBuilder create(String name, ResourceLocation cycleGroup) {
        return CRBogeyStyles.create(Railways.asResource(name), cycleGroup);
    }

    public static AllBogeyStyles.BogeyStyleBuilder create(ResourceLocation name, ResourceLocation cycleGroup) {
        return new AllBogeyStyles.BogeyStyleBuilder(name, cycleGroup);
    }

    public static void register() {
        Railways.LOGGER.info("Registered bogey styles from railways");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerClient() {
        BogeyCategoryHandlerClient.registerStyleCategory(Create.asResource((String)"standard"), CategoryIcon.standardSupplier("default_icon"));
        BogeyCategoryHandlerClient.registerStyleCategory(SINGLEAXLE_CYCLE_GROUP, CategoryIcon.standardSupplier("singleaxle_icon"));
        BogeyCategoryHandlerClient.registerStyleCategory(DOUBLEAXLE_CYCLE_GROUP, CategoryIcon.standardSupplier("freight_icon"));
        BogeyCategoryHandlerClient.registerStyleCategory(TRIPLEAXLE_CYCLE_GROUP, CategoryIcon.standardSupplier("radial_icon"));
        if (Mods.EXTENDEDBOGEYS.isLoaded) {
            BogeyCategoryHandlerClient.registerStyleCategory("extendedbogeys", CategoryIcon.standardSupplier("eb_triple_axle_icon"));
        }
    }
}

