/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.jea;

import de.melanx.jea.JustEnoughAdvancements;
import de.melanx.jea.api.client.IAdvancementInfo;
import de.melanx.jea.config.JeaConfig;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class AdvancementInfo
implements IAdvancementInfo {
    public final ResourceLocation id;
    private final DisplayInfo display;
    @Nullable
    private final ResourceLocation parent;
    private final Component formattedDisplayName;

    private AdvancementInfo(Advancement advancement) {
        this.id = advancement.m_138327_();
        this.display = Objects.requireNonNull(advancement.m_138320_());
        this.parent = advancement.m_138319_() == null ? null : advancement.m_138319_().m_138327_();
        this.formattedDisplayName = this.display.m_14977_().m_6881_().m_130940_(this.display.m_14992_().m_15552_());
    }

    private AdvancementInfo(FriendlyByteBuf buffer) {
        this.id = buffer.m_130281_();
        this.display = DisplayInfo.m_14988_((FriendlyByteBuf)buffer);
        this.parent = buffer.readBoolean() ? buffer.m_130281_() : null;
        this.formattedDisplayName = this.display.m_14977_().m_6881_().m_130940_(this.display.m_14992_().m_15552_());
    }

    private AdvancementInfo(IAdvancementInfo wrap) {
        this.id = wrap.getId();
        this.display = wrap.getDisplay();
        this.parent = wrap.getParent();
        this.formattedDisplayName = this.display.m_14977_().m_6881_().m_130940_(this.display.m_14992_().m_15552_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        this.display.m_14983_(buffer);
        buffer.writeBoolean(this.parent != null);
        if (this.parent != null) {
            buffer.m_130085_(this.parent);
        }
    }

    public static Optional<AdvancementInfo> create(Advancement advancement) {
        if (advancement.m_138320_() != null && (JeaConfig.hiddenAdvancements || !advancement.m_138320_().m_14997_())) {
            return Optional.of(new AdvancementInfo(advancement));
        }
        return Optional.empty();
    }

    public static AdvancementInfo read(FriendlyByteBuf buffer) {
        return new AdvancementInfo(buffer);
    }

    public static AdvancementInfo get(IAdvancementInfo info) {
        if (info instanceof AdvancementInfo) {
            AdvancementInfo impl = (AdvancementInfo)info;
            return impl;
        }
        JustEnoughAdvancements.getInstance().logger.warn("IAdvancementInfo found that is not an instance of AdvancementInfo. This should nt happen. Another mod may have created their own implementation of IAdvancementInfo which is not supported. Class is " + info.getClass());
        return new AdvancementInfo(info);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public DisplayInfo getDisplay() {
        return this.display;
    }

    @Override
    @Nullable
    public ResourceLocation getParent() {
        return this.parent;
    }

    @Override
    public Component getFormattedDisplayName() {
        return this.formattedDisplayName;
    }

    public String toString() {
        return "AdvancementInfo {id=" + this.id + ", display=" + this.display.m_14998_() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancementInfo that = (AdvancementInfo)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

