/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.jea.recipe;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.jea.AdvancementInfo;
import de.melanx.jea.api.client.Jea;
import de.melanx.jea.client.AdvancementDisplayHelper;
import de.melanx.jea.client.ClientAdvancementProgress;
import de.melanx.jea.client.ClientAdvancements;
import de.melanx.jea.recipe.AdvancementCompletion;
import de.melanx.jea.recipe.RecipeRenderSizeAdjust;
import io.github.noeppi_noeppi.libx.render.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.TooltipFlag;

public class AdvancementRecipe {
    private final AdvancementInfo info;
    @Nullable
    private final AdvancementInfo parent;

    public AdvancementRecipe(AdvancementInfo info) {
        this.info = info;
        this.parent = ClientAdvancements.getInfo(this.info.getParent());
    }

    public void setIngredients(IIngredients ii) {
        ii.setOutputs(Jea.ADVANCEMENT_TYPE, List.of(this.info));
        if (this.parent != null) {
            ii.setInputs(Jea.ADVANCEMENT_TYPE, List.of(this.parent));
        }
    }

    public void setRecipe(IRecipeLayout layout, IIngredients ii) {
        IGuiIngredientGroup group = layout.getIngredientsGroup(Jea.ADVANCEMENT_TYPE);
        group.addTooltipCallback((slot, type, info, list) -> {
            if (list.isEmpty()) {
                AdvancementDisplayHelper.addAdvancementTooltipToList(AdvancementInfo.get(info), list, (TooltipFlag)TooltipFlag.Default.NORMAL);
            }
        });
        group.init(group.getGuiIngredients().size(), false, 62, 0);
        if (this.parent != null) {
            group.init(group.getGuiIngredients().size(), true, Jea.ADVANCEMENT_RECIPE_RENDERER_TINY, 5, 5, 16, 16, 0, 0);
        }
        group.set(ii);
        RecipeRenderSizeAdjust.changeRecipeSizes(layout, VanillaTypes.ITEM);
        RecipeRenderSizeAdjust.changeRecipeSizes(layout, Jea.ADVANCEMENT_TYPE);
    }

    public void draw(PoseStack poseStack, double mouseX, double mouseY, IDrawableStatic complete, IDrawableStatic incomplete) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int width = font.m_92852_((FormattedText)this.info.getFormattedDisplayName());
        font.m_92889_(poseStack, this.info.getFormattedDisplayName(), 75.0f - (float)width / 2.0f, 27.0f, 0xFFFFFF);
        AdvancementCompletion advancementCompletion = this.getCriterionCompletion();
        poseStack.m_85836_();
        poseStack.m_85837_(129.0, 5.0, 0.0);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (mouseX >= 129.0 && mouseX <= 145.0 && mouseY >= 5.0 && mouseY <= 21.0) {
            RenderSystem.m_69465_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)RenderHelper.TEXTURE_WHITE);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        poseStack.m_85837_(0.0, 0.0, 10.0);
        poseStack.m_85841_(0.9411765f, 0.9411765f, 0.0f);
        poseStack.m_85837_(1.0, 1.0, 0.0);
        advancementCompletion.draw(poseStack, complete, incomplete);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        if (this.info.getDisplay() != null) {
            Component description = this.info.getDisplay().m_14985_();
            List lines = ComponentRenderUtils.m_94005_((FormattedText)description, (int)130, (Font)font);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
                Objects.requireNonNull(font);
                font.m_92744_(poseStack, formattedCharSequence, 10.0f, (float)(50 + (9 + 2) * i), 0xFFFFFF);
            }
        }
        mc.m_91269_().m_110104_().m_109911_();
    }

    public List<Component> getTooltip(double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (mouseX >= 129.0 && mouseX <= 145.0 && mouseY >= 5.0 && mouseY <= 21.0) {
            this.getCriterionCompletion().addTooltip(tooltip, this.info);
        }
        return tooltip;
    }

    private AdvancementCompletion getCriterionCompletion() {
        AdvancementProgress progress = ClientAdvancementProgress.getProgress(this.info.getId());
        if (progress != null) {
            if (progress.m_8193_()) {
                return AdvancementCompletion.COMPLETE;
            }
            if (progress.m_8206_()) {
                return AdvancementCompletion.PARTIALLY_COMPLETE;
            }
            return AdvancementCompletion.INCOMPLETE;
        }
        return AdvancementCompletion.INCOMPLETE;
    }
}

