/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.jea.recipe;

import de.melanx.jea.api.client.IAdvancementInfo;
import de.melanx.jea.api.client.Jea;
import de.melanx.jea.ingredient.AdvancementIngredientRenderer;
import java.lang.reflect.Field;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.client.renderer.Rect2i;

public class RecipeRenderSizeAdjust {
    private static Class<?> guiIngredientClass;
    private static Field rectangleField;
    private static Field ingredientRenderField;

    public static void changeRecipeSizes(IRecipeLayout layout, IIngredientType<?> type) {
        for (IGuiIngredient ingredient : layout.getIngredientsGroup(type).getGuiIngredients().values()) {
            try {
                Rect2i rect;
                Rect2i newRect;
                if (guiIngredientClass == null || rectangleField == null || ingredientRenderField == null) {
                    guiIngredientClass = Class.forName("mezz.jei.gui.ingredients.GuiIngredient");
                    rectangleField = guiIngredientClass.getDeclaredField("rect");
                    rectangleField.setAccessible(true);
                    ingredientRenderField = guiIngredientClass.getDeclaredField("ingredientRenderer");
                    ingredientRenderField.setAccessible(true);
                }
                if (!guiIngredientClass.isAssignableFrom(ingredient.getClass())) continue;
                IIngredientRenderer<IAdvancementInfo> render = (IIngredientRenderer<IAdvancementInfo>)ingredientRenderField.get(ingredient);
                if (type == Jea.ADVANCEMENT_TYPE && (render == null || render instanceof AdvancementIngredientRenderer)) {
                    ingredientRenderField.set(ingredient, Jea.ADVANCEMENT_RECIPE_RENDERER);
                    render = Jea.ADVANCEMENT_RECIPE_RENDERER;
                }
                if ((newRect = RecipeRenderSizeAdjust.newSize(render, rect = (Rect2i)rectangleField.get(ingredient))) == null) continue;
                rectangleField.set(ingredient, newRect);
            }
            catch (ClassCastException | NoClassDefFoundError | ReflectiveOperationException e) {
                guiIngredientClass = null;
                rectangleField = null;
            }
        }
    }

    private static Rect2i newSize(IIngredientRenderer<?> render, Rect2i size) {
        if (render == Jea.ADVANCEMENT_RECIPE_RENDERER) {
            return new Rect2i(size.m_110085_(), size.m_110086_(), 26, 26);
        }
        return null;
    }
}

