/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BreadBlock
extends Block {
    public static final EnumProperty<BreadPart> PART = EnumProperty.m_61587_((String)"part", BreadPart.class);

    public BreadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.X)).m_61124_(PART, (Comparable)((Object)BreadPart.WHOLE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PART, BlockStateProperties.f_61364_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directions;
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return state;
        }
        Direction dir = context.m_8125_();
        BlockPos placePos = context.m_8083_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (Direction direction : directions = new Direction[]{dir, dir.m_122424_(), dir.m_122427_(), dir.m_122428_()}) {
            BlockState test = context.m_43725_().m_8055_((BlockPos)pos.m_122159_((Vec3i)placePos, direction));
            if (!test.m_60713_((Block)this) || !this.canConnect(state, direction) || !this.canConnect(test, direction.m_122424_())) continue;
            state = this.connectTo(state, direction);
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (facing != Direction.UP && facing != Direction.DOWN && facingState.m_60713_((Block)this) && this.canConnect(state, facing) && this.canConnect(facingState, facing.m_122424_())) {
            return this.connectTo(state, facing);
        }
        return state;
    }

    private BlockState connectTo(BlockState state, Direction direction) {
        Direction.AxisDirection dir;
        BreadPart part = (BreadPart)((Object)state.m_61143_(PART));
        if (part == BreadPart.WHOLE) {
            part = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? BreadPart.RIGHT : BreadPart.LEFT;
            return (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)direction.m_122434_());
        }
        Direction.AxisDirection axisDirection = dir = part == BreadPart.LEFT ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        if ((part == BreadPart.LEFT || part == BreadPart.RIGHT) && direction.m_122421_() == dir) {
            part = BreadPart.MIDDLE;
            return (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)direction.m_122434_());
        }
        return state;
    }

    private boolean canConnect(BlockState state, Direction connectTo) {
        BreadPart part = (BreadPart)((Object)state.m_61143_(PART));
        if (part == BreadPart.WHOLE) {
            return true;
        }
        return connectTo.m_122434_() == state.m_61143_((Property)BlockStateProperties.f_61364_);
    }

    public static enum BreadPart implements StringRepresentable
    {
        LEFT,
        MIDDLE,
        RIGHT,
        WHOLE;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case LEFT -> "left";
                case MIDDLE -> "middle";
                case RIGHT -> "right";
                case WHOLE -> "whole";
            };
        }
    }
}

