/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core;

import architectspalette.core.config.APConfig;
import architectspalette.core.crafting.WarpingRecipe;
import architectspalette.core.datagen.GatherData;
import architectspalette.core.integration.APCriterion;
import architectspalette.core.integration.APTrades;
import architectspalette.core.integration.APVerticalSlabsCondition;
import architectspalette.core.loot.WitheredBoneLootModifier;
import architectspalette.core.registry.APBlockProperties;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APConfiguredFeatures;
import architectspalette.core.registry.APFeatures;
import architectspalette.core.registry.APItems;
import architectspalette.core.registry.APSounds;
import architectspalette.core.registry.MiscRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="architects_palette")
public class ArchitectsPalette {
    public static final String MOD_ID = "architects_palette";
    public static final Logger LOGGER = LogManager.getLogger((String)"architects_palette".toUpperCase());
    public static ArchitectsPalette instance;

    public ArchitectsPalette() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)APConfig.COMMON_CONFIG);
        MiscRegistry.PARTICLE_TYPES.register(modEventBus);
        APSounds.SOUNDS.register(modEventBus);
        APBlocks.BLOCKS.register(modEventBus);
        APItems.ITEMS.register(modEventBus);
        APFeatures.FEATURES.register(modEventBus);
        APConfiguredFeatures.CONFIGURED_FEATURES.register(modEventBus);
        APConfiguredFeatures.PLACED_FEATURES.register(modEventBus);
        modEventBus.addListener(EventPriority.LOWEST, this::setupCommon);
        modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
        modEventBus.addGenericListener(RecipeSerializer.class, this::registerRecipeSerializers);
        modEventBus.addGenericListener(GlobalLootModifierSerializer.class, this::registerLootSerializers);
        forgeBus.addListener(APConfiguredFeatures::biomeLoadEvent);
        CraftingHelper.register((IConditionSerializer)new APVerticalSlabsCondition.Serializer());
        GatherData.load();
    }

    void setupCommon(FMLCommonSetupEvent event) {
        APBlockProperties.registerFlammables();
        APTrades.registerTrades();
        APCriterion.register();
    }

    void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)new ResourceLocation(WarpingRecipe.TYPE.toString()), (Object)WarpingRecipe.TYPE);
        event.getRegistry().register((IForgeRegistryEntry)WarpingRecipe.SERIALIZER);
    }

    void registerLootSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)WitheredBoneLootModifier.SERIALIZER);
    }

    void setupClient(FMLClientSetupEvent event) {
        APBlockProperties.setupRenderLayers();
    }
}

