/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.datagen;

import architectspalette.content.blocks.BreadBlock;
import architectspalette.content.blocks.VerticalSlabBlock;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APItems;
import architectspalette.core.registry.util.BlockNode;
import architectspalette.core.registry.util.StoneBlockSet;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class Blockstates
extends BlockStateProvider {
    public Blockstates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (BlockNode n : APBlocks.boards) {
            this.boardModel(n.getName(), n.get());
        }
        this.cerebralTiles((Block)APBlocks.CEREBRAL_BLOCK.getChild(BlockNode.BlockType.TILES).get());
        BlockNode.forAllBaseNodes(this::processBlockNode);
        this.breadBlock(APBlocks.BREAD_BLOCK.get());
        this.breadSlab((Block)APBlocks.BREAD_BLOCK.getChild(BlockNode.BlockType.SLAB).get());
        this.itemModels().basicItem(APItems.ORACLE_JELLY.getId());
        this.itemModels().basicItem(APItems.CEREBRAL_PLATE.getId());
    }

    private static ResourceLocation inBlockFolder(ResourceLocation original) {
        return new ResourceLocation(original.m_135827_(), "block/" + original.m_135815_());
    }

    private static ResourceLocation inBlockFolder(ResourceLocation original, String append) {
        return new ResourceLocation(original.m_135827_(), "block/" + original.m_135815_() + append);
    }

    private static ResourceLocation inMinecraftBlock(String name) {
        return new ResourceLocation("minecraft", "block/" + name);
    }

    private static String fileName(ResourceLocation block) {
        return "block/" + block.m_135815_();
    }

    private static ResourceLocation inAPBlockFolder(String name) {
        return Blockstates.modResourceLocation("block/" + name);
    }

    private static ResourceLocation modResourceLocation(String name) {
        return new ResourceLocation("architects_palette", name);
    }

    private static int getYRotation(Direction direction) {
        return switch (direction) {
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
    }

    private static ModelFile blockModel(String name) {
        return new ModelFile.UncheckedModelFile(Blockstates.inAPBlockFolder(name));
    }

    private void simpleBlockstate(Block block, ModelFile model) {
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(model)});
    }

    private void verticalSlabBlock(VerticalSlabBlock block, ResourceLocation baseBlock) {
        ResourceLocation texture = Blockstates.inBlockFolder(baseBlock);
        ModelBuilder slab = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().m_135815_(), Blockstates.inAPBlockFolder("vertical_slab"))).texture("bottom", texture)).texture("top", texture)).texture("side", texture);
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> this.lambda$verticalSlabBlock$0((ModelFile)slab, baseBlock, arg_0), new Property[]{BlockStateProperties.f_61362_});
        this.simpleBlockItem(block, (ModelFile)slab);
    }

    private void processBoardBlockSet(StoneBlockSet set) {
        ResourceLocation base = set.getRegistryPart(StoneBlockSet.SetComponent.BLOCK).getId();
        set.forEachPart((part, block) -> {
            String name = Objects.requireNonNull(block.getRegistryName()).m_135815_();
            switch (part) {
                case BLOCK: {
                    this.boardModel(base.m_135815_(), set.get());
                    break;
                }
                case SLAB: {
                    this.slabBlock((SlabBlock)block, base, Blockstates.inBlockFolder(base));
                    this.simpleBlockItem((Block)block, Blockstates.blockModel(name));
                    break;
                }
                case VERTICAL_SLAB: {
                    this.verticalSlabBlock((VerticalSlabBlock)((Object)block), base);
                    break;
                }
                case STAIRS: {
                    this.stairsBlock((StairBlock)block, Blockstates.inBlockFolder(base));
                    this.simpleBlockItem((Block)block, Blockstates.blockModel(name));
                }
            }
        });
    }

    private void boardModel(String boardname, Block board) {
        ResourceLocation boardParent = Blockstates.inAPBlockFolder("boards/parent");
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/boards/" + boardname + "_item", boardParent)).texture("even", Blockstates.inAPBlockFolder(boardname))).texture("odd", Blockstates.inAPBlockFolder(boardname + "_odd"));
        ((ItemModelBuilder)this.itemModels().getBuilder(boardname)).parent((ModelFile)model);
        this.simpleBlock(board);
    }

    private void processBlockNode(BlockNode node) {
        if (!node.getFlag(BlockNode.ExcludeFlag.MODELS)) {
            Block block = node.get();
            String name = block.getRegistryName().m_135815_();
            ResourceLocation parentTexture = node.parent != null ? Blockstates.inBlockFolder(node.parent.getId()) : Blockstates.inBlockFolder(node.getId());
            switch (node.type) {
                case NUB: {
                    break;
                }
                case SLAB: {
                    this.slabBlock((SlabBlock)block, node.parent.getId(), parentTexture);
                    this.simpleBlockItem(block, Blockstates.blockModel(name));
                    break;
                }
                case VERTICAL_SLAB: {
                    this.verticalSlabBlock((VerticalSlabBlock)block, node.parent.getId());
                    break;
                }
                case STAIRS: {
                    this.stairsBlock((StairBlock)block, parentTexture);
                    this.simpleBlockItem(block, Blockstates.blockModel(name));
                    break;
                }
                case WALL: {
                    this.wallBlock((WallBlock)block, parentTexture);
                    BlockModelBuilder inventory = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Blockstates.fileName(node.getId()), Blockstates.inMinecraftBlock("wall_inventory"))).texture("wall", parentTexture);
                    this.simpleBlockItem(block, (ModelFile)inventory);
                    break;
                }
                case FENCE: {
                    this.fenceBlock((FenceBlock)block, parentTexture);
                    this.simpleBlockItem(block, Blockstates.blockModel(name));
                    break;
                }
                case PILLAR: {
                    this.logBlock((RotatedPillarBlock)block);
                    this.simpleBlockItem(block, Blockstates.blockModel(name));
                    break;
                }
                default: {
                    ResourceLocation mid;
                    ResourceLocation top;
                    ResourceLocation bot = switch (node.style) {
                        default -> {
                            top = Blockstates.inBlockFolder(node.getId());
                            mid = Blockstates.inBlockFolder(node.getId());
                            yield Blockstates.inBlockFolder(node.getId());
                        }
                        case BlockNode.Style.TOP_SIDES -> {
                            top = Blockstates.inBlockFolder(node.getId(), "_top");
                            mid = Blockstates.inBlockFolder(node.getId());
                            yield Blockstates.inBlockFolder(node.getId(), "_top");
                        }
                        case BlockNode.Style.TOP_SIDE_BOTTOM -> {
                            top = Blockstates.inBlockFolder(node.getId(), "_top");
                            mid = Blockstates.inBlockFolder(node.getId());
                            yield Blockstates.inBlockFolder(node.getId(), "_bottom");
                        }
                    };
                    String filename = Blockstates.fileName(node.getId());
                    BlockModelBuilder model = switch (node.style) {
                        default -> throw new IncompatibleClassChangeError();
                        case BlockNode.Style.CUBE -> (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(filename, Blockstates.inMinecraftBlock("cube_all"))).texture("all", mid);
                        case BlockNode.Style.TOP_SIDES -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(filename, Blockstates.inMinecraftBlock("cube_column"))).texture("end", top)).texture("side", mid);
                        case BlockNode.Style.TOP_SIDE_BOTTOM -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(filename, Blockstates.inMinecraftBlock("cube_bottom_top"))).texture("top", top)).texture("side", mid)).texture("bottom", bot);
                    };
                    this.simpleBlockstate(block, (ModelFile)model);
                    this.simpleBlockItem(block, (ModelFile)model);
                }
            }
        }
        for (BlockNode child : node.children) {
            this.processBlockNode(child);
        }
    }

    private void breadBlock(Block block) {
        ResourceLocation heel = Blockstates.inAPBlockFolder("bread_block_end");
        ResourceLocation inside = Blockstates.inAPBlockFolder("bread_block_inside");
        ResourceLocation whole_bottom = Blockstates.inAPBlockFolder("bread_block_bottom");
        ResourceLocation middle_bottom = Blockstates.inAPBlockFolder("bread_block_bottom_middle");
        ResourceLocation left_bottom = Blockstates.inAPBlockFolder("bread_block_bottom_left");
        ResourceLocation right_bottom = Blockstates.inAPBlockFolder("bread_block_bottom_right");
        ResourceLocation whole_top = Blockstates.inAPBlockFolder("bread_block_top");
        ResourceLocation middle_top = Blockstates.inAPBlockFolder("bread_block_top_middle");
        ResourceLocation left_top = Blockstates.inAPBlockFolder("bread_block_top_left");
        ResourceLocation right_top = Blockstates.inAPBlockFolder("bread_block_top_right");
        ResourceLocation whole_side = Blockstates.inAPBlockFolder("bread_block_side");
        ResourceLocation middle_side = Blockstates.inAPBlockFolder("bread_block_side_middle");
        ResourceLocation left_side = Blockstates.inAPBlockFolder("bread_block_side_left");
        ResourceLocation right_side = Blockstates.inAPBlockFolder("bread_block_side_right");
        ModelBuilder wholeModel = ((BlockModelBuilder)this.models().cube("block/bread_block_whole", whole_bottom, whole_top, whole_side, whole_side, whole_side, whole_side)).texture("particle", inside);
        ModelBuilder rightModel = ((BlockModelBuilder)this.models().cube("block/bread_block_right", right_bottom, right_top, heel, inside, right_side, left_side)).texture("particle", inside);
        ModelBuilder leftModel = ((BlockModelBuilder)this.models().cube("block/bread_block_left", left_bottom, left_top, inside, heel, left_side, right_side)).texture("particle", inside);
        ModelBuilder middleModel = ((BlockModelBuilder)this.models().cube("block/bread_block_middle", middle_bottom, middle_top, inside, inside, middle_side, middle_side)).texture("particle", inside);
        this.getVariantBuilder(block).forAllStates(arg_0 -> Blockstates.lambda$breadBlock$2((ModelFile)wholeModel, (ModelFile)leftModel, (ModelFile)rightModel, (ModelFile)middleModel, arg_0));
        ((ItemModelBuilder)this.itemModels().getBuilder("bread_block")).parent((ModelFile)rightModel);
    }

    private void breadSlab(Block block) {
        ResourceLocation top = Blockstates.inAPBlockFolder("bread_block_inside");
        ResourceLocation sides = Blockstates.inAPBlockFolder("bread_block_side");
        ModelBuilder doubleModel = this.models().cubeColumn("double_bread_slab", sides, top);
        ModelBuilder upper = this.models().slabTop("bread_slab_top", sides, top, top);
        ModelBuilder lower = this.models().slab("bread_slab", sides, top, top);
        this.slabBlock((SlabBlock)block, (ModelFile)lower, (ModelFile)upper, (ModelFile)doubleModel);
        this.simpleBlockItem(block, (ModelFile)lower);
    }

    private void cerebralTiles(Block block) {
        ModelBuilder tex0 = this.models().cubeAll("cerebral_tiles", Blockstates.inAPBlockFolder("cerebral_tiles"));
        ModelBuilder tex1 = this.models().cubeAll("cerebral_tiles_1", Blockstates.inAPBlockFolder("cerebral_tiles_1"));
        ModelBuilder tex2 = this.models().cubeAll("cerebral_tiles_2", Blockstates.inAPBlockFolder("cerebral_tiles_2"));
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)tex0), new ConfiguredModel((ModelFile)tex1), new ConfiguredModel((ModelFile)tex2)});
        this.simpleBlockItem(block, (ModelFile)tex0);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$breadBlock$2(ModelFile wholeModel, ModelFile leftModel, ModelFile rightModel, ModelFile middleModel, BlockState state) {
        int yRotation;
        BreadBlock.BreadPart part = (BreadBlock.BreadPart)((Object)state.m_61143_(BreadBlock.PART));
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
        if (part == BreadBlock.BreadPart.WHOLE) {
            return ConfiguredModel.builder().modelFile(wholeModel).build();
        }
        int n = yRotation = axis == Direction.Axis.X ? 270 : 0;
        ModelFile model = part == BreadBlock.BreadPart.LEFT ? leftModel : (part == BreadBlock.BreadPart.RIGHT ? rightModel : middleModel);
        return ConfiguredModel.builder().modelFile(model).rotationY(yRotation).build();
    }

    private /* synthetic */ ConfiguredModel[] lambda$verticalSlabBlock$0(ModelFile slab, ResourceLocation baseBlock, BlockState state) {
        VerticalSlabBlock.VerticalSlabType type = (VerticalSlabBlock.VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE));
        if (type != VerticalSlabBlock.VerticalSlabType.DOUBLE) {
            return ConfiguredModel.builder().modelFile(slab).rotationY(Blockstates.getYRotation(type.direction)).uvLock(true).build();
        }
        return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(baseBlock)).build();
    }
}

