/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.model.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class SpriteShift {
    private static final Map<String, SpriteShift> entries = new HashMap<String, SpriteShift>();
    protected TextureAtlasSprite from;
    protected TextureAtlasSprite to;

    public static SpriteShift getShift(ResourceLocation from_block, ResourceLocation to_block) {
        String key = from_block.toString() + "->" + to_block.toString();
        if (entries.containsKey(key)) {
            return entries.get(key);
        }
        SpriteShift shift = new SpriteShift(from_block, to_block);
        entries.put(key, shift);
        return shift;
    }

    public static SpriteShift getShift(String from_block, String to_block) {
        return SpriteShift.getShift(new ResourceLocation("architects_palette", from_block), new ResourceLocation("architects_palette", to_block));
    }

    private SpriteShift(ResourceLocation from_block, ResourceLocation to_block) {
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        this.from = (TextureAtlasSprite)atlas.apply(from_block);
        this.to = (TextureAtlasSprite)atlas.apply(to_block);
    }

    public float getUShift() {
        return this.to.m_118409_() - this.from.m_118409_();
    }

    public float getVShift() {
        return this.to.m_118411_() - this.from.m_118411_();
    }

    public float getVHeight() {
        return this.from.m_118412_() - this.from.m_118411_();
    }
}

