/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry;

import architectspalette.content.worldgen.features.configs.CrystalClusterConfig;
import architectspalette.core.config.APConfig;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APFeatures;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class APConfiguredFeatures {
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"architects_palette");
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"architects_palette");
    private static final Supplier<TreeConfiguration> TWISTED_TREE_CONFIG = () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)APBlocks.TWISTED_LOG.get()).m_49966_()), (TrunkPlacer)new ForkingTrunkPlacer(5, 2, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)APBlocks.TWISTED_LEAVES.get()).m_49966_()), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68251_();
    public static final RegistryObject<ConfiguredFeature<?, ?>> TWISTED_TREE = APConfiguredFeatures.registerConfigured("twisted_tree", () -> Feature.f_65760_, TWISTED_TREE_CONFIG);
    private static final Supplier<CrystalClusterConfig> HELIODOR_CLUSTER_CONFIG = () -> new CrystalClusterConfig(1, 7, ((Block)APBlocks.HELIODOR_ROD.get()).m_49966_(), true, Blocks.f_50137_.m_49966_());
    public static final RegistryObject<ConfiguredFeature<?, ?>> HELIODOR_CLUSTER = APConfiguredFeatures.registerConfigured("heliodor_cluster", APFeatures.CRYSTAL_CLUSTER, HELIODOR_CLUSTER_CONFIG);
    public static final RegistryObject<PlacedFeature> HELIODOR_CLUSTER_PLACED = APConfiguredFeatures.registerPlaced("heliodor_cluster", HELIODOR_CLUSTER, new PlacementModifier[]{CountPlacement.m_191628_((int)7), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_()});
    private static final Supplier<CrystalClusterConfig> EKANITE_CLUSTER_CONFIG = () -> new CrystalClusterConfig(1, 6, ((Block)APBlocks.EKANITE_ROD.get()).m_49966_(), true, Blocks.f_50137_.m_49966_());
    public static final RegistryObject<ConfiguredFeature<?, ?>> EKANITE_CLUSTER = APConfiguredFeatures.registerConfigured("ekanite_cluster", APFeatures.CRYSTAL_CLUSTER, EKANITE_CLUSTER_CONFIG);
    public static final RegistryObject<PlacedFeature> EKANITE_CLUSTER_PLACED = APConfiguredFeatures.registerPlaced("ekanite_cluster", EKANITE_CLUSTER, new PlacementModifier[]{CountPlacement.m_191628_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_()});
    private static final Supplier<CrystalClusterConfig> HANGING_MONAZITE_CLUSTER_CONFIG = () -> new CrystalClusterConfig(0, 7, ((Block)APBlocks.MONAZITE_ROD.get()).m_49966_(), true, Blocks.f_50137_.m_49966_());
    public static final RegistryObject<ConfiguredFeature<?, ?>> HANGING_MONAZITE_CLUSTER = APConfiguredFeatures.registerConfigured("hanging_monazite_cluster", APFeatures.CRYSTAL_CLUSTER, HANGING_MONAZITE_CLUSTER_CONFIG);
    public static final RegistryObject<PlacedFeature> HANGING_MONAZITE_CLUSTER_PLACED = APConfiguredFeatures.registerPlaced("hanging_monazite_cluster", HANGING_MONAZITE_CLUSTER, new PlacementModifier[]{CountPlacement.m_191628_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_()});
    private static final Supplier<CrystalClusterConfig> GROUNDED_MONAZITE_CLUSTER_CONFIG = () -> new CrystalClusterConfig(0, 6, ((Block)APBlocks.MONAZITE_ROD.get()).m_49966_(), false, Blocks.f_50137_.m_49966_());
    public static final RegistryObject<ConfiguredFeature<?, ?>> GROUNDED_MONAZITE_CLUSTER = APConfiguredFeatures.registerConfigured("grounded_monazite_cluster", APFeatures.CRYSTAL_CLUSTER, GROUNDED_MONAZITE_CLUSTER_CONFIG);
    public static final RegistryObject<PlacedFeature> GROUNDED_MONAZITE_CLUSTER_PLACED = APConfiguredFeatures.registerPlaced("grounded_monazite_cluster", GROUNDED_MONAZITE_CLUSTER, new PlacementModifier[]{CountPlacement.m_191628_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_()});

    private static <FC extends FeatureConfiguration> RegistryObject<ConfiguredFeature<?, ?>> registerConfigured(String name, Supplier<Feature<FC>> feature, Supplier<FC> configSupplier) {
        return CONFIGURED_FEATURES.register(name, () -> new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)configSupplier.get()));
    }

    private static RegistryObject<PlacedFeature> registerPlaced(String name, RegistryObject<ConfiguredFeature<?, ?>> configuredFeature, PlacementModifier ... placements) {
        return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)configuredFeature.getHolder().get(), List.of(placements)));
    }

    public static void biomeLoadEvent(BiomeLoadingEvent event) {
        if (APConfig.worldGenCheck(APConfig.NETHER_CRYSTAL_TOGGLE)) {
            Biome.BiomeCategory category = event.getCategory();
            if (category.equals((Object)Biome.BiomeCategory.NETHER) && APConfiguredFeatures.biomeHasName(event, "basalt")) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_DECORATION).add((Holder)HELIODOR_CLUSTER_PLACED.getHolder().get());
            }
            if (category.equals((Object)Biome.BiomeCategory.NETHER) && APConfiguredFeatures.biomeHasName(event, "warped")) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_DECORATION).add((Holder)EKANITE_CLUSTER_PLACED.getHolder().get());
            }
            if (category.equals((Object)Biome.BiomeCategory.NETHER) && APConfiguredFeatures.biomeHasName(event, "wastes")) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_DECORATION).add((Holder)HANGING_MONAZITE_CLUSTER_PLACED.getHolder().get());
            }
            if (category.equals((Object)Biome.BiomeCategory.NETHER) && APConfiguredFeatures.biomeHasName(event, "crimson")) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_DECORATION).add((Holder)GROUNDED_MONAZITE_CLUSTER_PLACED.getHolder().get());
            }
        }
    }

    private static boolean biomeHasName(BiomeLoadingEvent biome, String ... names) {
        if (biome.getName() != null) {
            String biomeName = biome.getName().toString().toLowerCase();
            return Arrays.stream(names).anyMatch(biomeName::contains);
        }
        return false;
    }
}

