/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class APSounds {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"architects_palette");
    public static final RegistryObject<SoundEvent> BLOCK_ENTWINE_PLACE = APSounds.register("block.entwine.place");
    public static final RegistryObject<SoundEvent> BLOCK_ENTWINE_HIT = APSounds.register("block.entwine.hit");
    public static final RegistryObject<SoundEvent> ITEM_WARPS = APSounds.register("block.warping.item_warps");
    public static final RegistryObject<SoundEvent> CAGE_LANTERN_TOGGLE_ON = APSounds.register("block.cage_lantern.toggle_on");
    public static final RegistryObject<SoundEvent> CAGE_LANTERN_TOGGLE_OFF = APSounds.register("block.cage_lantern.toggle_off");
    public static final RegistryObject<SoundEvent> WIZARD_BLAST = APSounds.register("block.wizard_deflect");
    public static final RegistryObject<SoundEvent> HADALINE_ACTIVATE = APSounds.register("block.chiseled_hadaline.activate");

    private static RegistryObject<SoundEvent> register(String key) {
        return SOUNDS.register(key, () -> new SoundEvent(new ResourceLocation("architects_palette", key)));
    }

    private static class LazySoundType
    extends SoundType {
        private final LazyLoadedValue<SoundEvent> breakSound;
        private final LazyLoadedValue<SoundEvent> stepSound;
        private final LazyLoadedValue<SoundEvent> placeSound;
        private final LazyLoadedValue<SoundEvent> hitSound;
        private final LazyLoadedValue<SoundEvent> fallSound;

        public LazySoundType(float volumeIn, float pitchIn, LazyLoadedValue<SoundEvent> breakSoundIn, LazyLoadedValue<SoundEvent> stepSoundIn, LazyLoadedValue<SoundEvent> placeSoundIn, LazyLoadedValue<SoundEvent> hitSoundIn, LazyLoadedValue<SoundEvent> fallSoundIn) {
            super(volumeIn, pitchIn, SoundEvents.f_12442_, SoundEvents.f_12450_, SoundEvents.f_12447_, SoundEvents.f_12446_, SoundEvents.f_12445_);
            this.breakSound = breakSoundIn;
            this.stepSound = stepSoundIn;
            this.placeSound = placeSoundIn;
            this.hitSound = hitSoundIn;
            this.fallSound = fallSoundIn;
        }

        public float m_56773_() {
            return this.f_56731_;
        }

        public float m_56774_() {
            return this.f_56732_;
        }

        public SoundEvent m_56775_() {
            return (SoundEvent)this.breakSound.m_13971_();
        }

        public SoundEvent m_56776_() {
            return (SoundEvent)this.stepSound.m_13971_();
        }

        public SoundEvent m_56777_() {
            return (SoundEvent)this.placeSound.m_13971_();
        }

        public SoundEvent m_56778_() {
            return (SoundEvent)this.hitSound.m_13971_();
        }

        public SoundEvent m_56779_() {
            return (SoundEvent)this.fallSound.m_13971_();
        }
    }

    public static class APSoundTypes {
        public static final SoundType ENTWINE = new LazySoundType(1.0f, 1.0f, (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(() -> SoundEvents.f_144113_), (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(() -> SoundEvents.f_11987_), (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(BLOCK_ENTWINE_PLACE), (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(BLOCK_ENTWINE_HIT), (LazyLoadedValue<SoundEvent>)new LazyLoadedValue(() -> SoundEvents.f_11984_));
        public static final SoundType ENDER_PEARL = new SoundType(1.0f, 2.0f, SoundEvents.f_12348_, SoundEvents.f_12349_, SoundEvents.f_12350_, SoundEvents.f_12351_, SoundEvents.f_12405_);
    }
}

