/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.config.IEditModeConfig;
import mezz.jei.common.ingredients.IngredientFilter;
import mezz.jei.core.config.IngredientBlacklistType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class EditModeConfig
implements IEditModeConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] defaultBlacklist = new String[0];
    private final Set<String> blacklist = new LinkedHashSet<String>();
    @Nullable
    private final Path blacklistConfigFile;

    public EditModeConfig(@Nullable Path blacklistConfigFile) {
        Collections.addAll(this.blacklist, defaultBlacklist);
        if (blacklistConfigFile != null) {
            this.blacklistConfigFile = blacklistConfigFile;
            this.loadBlacklistConfig();
        } else {
            this.blacklistConfigFile = null;
        }
    }

    private void loadBlacklistConfig() {
        if (this.blacklistConfigFile != null && Files.exists(this.blacklistConfigFile, new LinkOption[0])) {
            try {
                List<String> strings = Files.readAllLines(this.blacklistConfigFile);
                this.blacklist.clear();
                this.blacklist.addAll(strings);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load blacklist from file {}", (Object)this.blacklistConfigFile, (Object)e);
            }
        }
    }

    private void saveBlacklist() {
        if (this.blacklistConfigFile != null) {
            try {
                Files.write(this.blacklistConfigFile, this.blacklist, new OpenOption[0]);
                LOGGER.debug("Saved blacklist config file: {}", (Object)this.blacklistConfigFile);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save blacklist to file {}", (Object)this.blacklistConfigFile, (Object)e);
            }
        }
    }

    @Override
    public <V> void addIngredientToConfigBlacklist(IngredientFilter ingredientFilter, ITypedIngredient<V> typedIngredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        if (this.addIngredientToConfigBlacklistInternal(ingredientFilter, typedIngredient, blacklistType, ingredientHelper)) {
            this.saveBlacklist();
        }
    }

    private <V> boolean addIngredientToConfigBlacklistInternal(IngredientFilter ingredientFilter, ITypedIngredient<V> typedIngredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String wildcardUid = EditModeConfig.getIngredientUid(typedIngredient, IngredientBlacklistType.WILDCARD, ingredientHelper);
        if (blacklistType == IngredientBlacklistType.ITEM) {
            Set<String> wildcardIndividualUids;
            String uid = EditModeConfig.getIngredientUid(typedIngredient, blacklistType, ingredientHelper);
            if (wildcardUid.equals(uid)) {
                return this.blacklist.add(wildcardUid);
            }
            boolean updated = this.blacklist.add(uid);
            if (updated && this.blacklist.containsAll(wildcardIndividualUids = EditModeConfig.getMatchingItemUids(typedIngredient, ingredientHelper, ingredientFilter))) {
                this.blacklist.removeAll(wildcardIndividualUids);
                this.blacklist.add(wildcardUid);
            }
            return updated;
        }
        if (blacklistType == IngredientBlacklistType.WILDCARD) {
            Set<String> wildcardIndividualUids = EditModeConfig.getMatchingItemUids(typedIngredient, ingredientHelper, ingredientFilter);
            return this.blacklist.removeAll(wildcardIndividualUids) | this.blacklist.add(wildcardUid);
        }
        return false;
    }

    private static <V> Set<String> getMatchingItemUids(ITypedIngredient<V> typedIngredient, IIngredientHelper<V> ingredientHelper, IngredientFilter ingredientFilter) {
        String wildcardUid;
        Function<ITypedIngredient<ITypedIngredient<V>>, String> wildcardUidFunction = i -> EditModeConfig.getIngredientUid(i, IngredientBlacklistType.WILDCARD, ingredientHelper);
        Function<ITypedIngredient, String> itemUidFunction = i -> EditModeConfig.getIngredientUid(i, IngredientBlacklistType.ITEM, ingredientHelper);
        String itemUid = itemUidFunction.apply(typedIngredient);
        if (itemUid.equals(wildcardUid = wildcardUidFunction.apply(typedIngredient))) {
            return Set.of(itemUid);
        }
        List<ITypedIngredient<V>> wildcardMatches = ingredientFilter.searchForWildcardMatches(typedIngredient, ingredientHelper, wildcardUidFunction);
        return wildcardMatches.stream().map(itemUidFunction).collect(Collectors.toSet());
    }

    @Override
    public <V> void removeIngredientFromConfigBlacklist(IngredientFilter ingredientFilter, ITypedIngredient<V> typedIngredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        boolean updated = false;
        if (blacklistType == IngredientBlacklistType.ITEM) {
            String wildUid = EditModeConfig.getIngredientUid(typedIngredient, IngredientBlacklistType.WILDCARD, ingredientHelper);
            if (this.blacklist.contains(wildUid)) {
                this.blacklist.remove(wildUid);
                Set<String> uids = EditModeConfig.getMatchingItemUids(typedIngredient, ingredientHelper, ingredientFilter);
                this.blacklist.addAll(uids);
                updated = true;
            }
        } else if (blacklistType == IngredientBlacklistType.WILDCARD) {
            Set<String> uids = EditModeConfig.getMatchingItemUids(typedIngredient, ingredientHelper, ingredientFilter);
            updated = this.blacklist.removeAll(uids);
        }
        String uid = EditModeConfig.getIngredientUid(typedIngredient, blacklistType, ingredientHelper);
        if (updated |= this.blacklist.remove(uid)) {
            this.saveBlacklist();
        }
    }

    @Override
    public <V> boolean isIngredientOnConfigBlacklist(ITypedIngredient<V> typedIngredient, IIngredientHelper<V> ingredientHelper) {
        for (IngredientBlacklistType ingredientBlacklistType : IngredientBlacklistType.VALUES) {
            if (!this.isIngredientOnConfigBlacklist(typedIngredient, ingredientBlacklistType, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    public <V> boolean isIngredientOnConfigBlacklist(ITypedIngredient<V> typedIngredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = EditModeConfig.getIngredientUid(typedIngredient, blacklistType, ingredientHelper);
        return this.blacklist.contains(uid);
    }

    private static <V> String getIngredientUid(ITypedIngredient<V> typedIngredient, IngredientBlacklistType blacklistType, IIngredientHelper<V> ingredientHelper) {
        V ingredient = typedIngredient.getIngredient();
        return switch (blacklistType) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientBlacklistType.ITEM -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
            case IngredientBlacklistType.WILDCARD -> ingredientHelper.getWildcardId(ingredient);
        };
    }
}

