/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file.serializers;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.common.config.file.serializers.DeserializeResult;
import mezz.jei.common.config.file.serializers.IConfigValueSerializer;

public class EnumSerializer<T extends Enum<T>>
implements IConfigValueSerializer<T> {
    private final Class<T> enumClass;
    private final Collection<T> validValues;

    public EnumSerializer(Class<T> enumClass) {
        this.enumClass = enumClass;
        this.validValues = List.of((Enum[])enumClass.getEnumConstants());
    }

    public EnumSerializer(Class<T> enumClass, Collection<T> validValues) {
        this.enumClass = enumClass;
        this.validValues = validValues;
    }

    @Override
    public String serialize(T value) {
        return ((Enum)value).name();
    }

    @Override
    public DeserializeResult<T> deserialize(String string) {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        try {
            T value = Enum.valueOf(this.enumClass, string);
            return new DeserializeResult<T>(value);
        }
        catch (IllegalArgumentException e) {
            return new DeserializeResult<Object>(null, "Invalid enum name: %s".formatted(e.getMessage()));
        }
    }

    @Override
    public String getValidValuesDescription() {
        String names = this.validValues.stream().map(Enum::name).collect(Collectors.joining(", "));
        return "[%s]".formatted(names);
    }
}

